package com.voxeet.sdk.utils;

import android.support.annotation.Nullable;
import android.util.Base64;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Authentication {

    final static String COMMA = ":";

    public static String basicAuthHeaderValue(String id, String password) {
        String ps = id + COMMA + password;

        return "basic " + Base64.encodeToString(ps.getBytes(), Base64.NO_WRAP);
    }


    @Nullable
    public static String compute(String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] result = digest.digest(password.getBytes("UTF-8"));

            StringBuilder sb = new StringBuilder();

            for (byte b : result) // This is your byte[] result..{
                sb.append(String.format("%02X", b));

            return sb.toString();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        return null;
    }
}
