package com.voxeet.sdk.models;

public enum Status {
	OFFLINE("OFFLINE"),
	AVAILABLE("AVAILABLE"),
    BUSY("BUSY"),
	AWAY("AWAY"),
	HIDDEN("HIDDEN");

    private final String value;

    Status(String value) {
        this.value = value;
    }

    public String value() {
        return value;
    }

    public static Status fromId(String value) {
        switch (value) {
            case "OFFLINE":
                return OFFLINE;
            case "AVAILABLE":
                return AVAILABLE;
            case "BUSY":
                return BUSY;
            case "AWAY":
                return AWAY;
            case "HIDDEN":
                return HIDDEN;
        }

        throw new IllegalArgumentException("No presence matching[" + value + "]");
    }


}
