package com.voxeet.sdk.media.camera;

import android.content.Context;
import android.support.annotation.Nullable;

import com.voxeet.android.media.video.Camera2Enumerator;

public class CameraEnumeratorLollipopWrapper extends CameraInformationProvider<Camera2Enumerator> {

    public CameraEnumeratorLollipopWrapper(Context context) {
        super(new Camera2Enumerator(context));

        setDefaultCameraFront(true);
    }

    @Nullable
    @Override
    public String getFrontCameraName() {
        try {
            return getEnumerator().getNameOfFrontFacingDevice();
        } catch (AssertionError e) {
            e.printStackTrace();
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    @Override
    public String getBackCameraName() {
        try {
            return getEnumerator().getNameOfBackFacingDevice();
        } catch (AssertionError e) {
            e.printStackTrace();
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }
}
