package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Authentication;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.UPDATE_PASSWORD)
public class UpdatePasswordEvent extends Event {

    private String userId;

    private String oldPassword;

    private String newPassword;

    public UpdatePasswordEvent(String userId, String oldPassword, String newPassword) {
        this.userId = userId;

        this.oldPassword = Authentication.compute(oldPassword);

        this.newPassword = Authentication.compute(newPassword);
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getOldPassword() {
        return oldPassword;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public String getNewPassword() {
        return newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    @Override
    public String getType() {
        return EventNames.UPDATE_PASSWORD;
    }
}
