package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.voxeet.sdk.models.MeetingNotification;

@JsonIgnoreProperties(ignoreUnknown = true)
public class UpdateMeetingSettingsEvent {

    private MeetingNotification notification;

    public UpdateMeetingSettingsEvent(String notificationType) {

        notification = MeetingNotification.fromName(notificationType);

        if (notification == null) {
            throw new IllegalStateException("Invalid type");
        }
    }

    public MeetingNotification getNotificationType() {
        return notification;
    }

    public void setNotificationType(MeetingNotification notification) {
        this.notification = notification;
    }
}
