package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.RecordingStatus;
import com.voxeet.sdk.models.abs.Conference;
import com.voxeet.sdk.models.abs.ConferenceUser;
import com.voxeet.sdk.models.impl.DefaultConferenceInfos;
import com.voxeet.sdk.models.impl.DefaultUserProfile;

import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.OWN_USER_INVITED)
public class OwnUserInvited extends Event {

    private String userId;

    @JsonProperty("conference")
    private DefaultConferenceInfos conferenceInfos;

    public List<DefaultUserProfile> getGuests() {
        return guests;
    }

    public void setGuests(List<DefaultUserProfile> guests) {
        this.guests = guests;
    }

    private List<DefaultUserProfile> guests;

    public Conference getConference() {
        Conference conference = new Conference();
        conference.setConferenceInfos(conferenceInfos);
        conference.setHasBeenCreated(true);
        conference.setDemo(false);
        conference.setConferenceType(conferenceInfos.getConferenceType());
        conference.setMeetingId(conferenceInfos.getMeetingId());
        conference.setConferenceId(conferenceInfos.getConferenceId());
        conference.setDescription(conferenceInfos.getDescription());
        conference.setLocation(conferenceInfos.getLocation());
        conference.setGuestAccess(false);
        conference.setOffline(false);
        conference.setRecorded(false);
        conference.setRecordingStatus(RecordingStatus.NOT_RECORDING);

        for (DefaultUserProfile profile : guests) {
            conference.getConferenceUsers().add(new ConferenceUser(profile));
        }

        return conference;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DefaultConferenceInfos getConferenceInfos() {
        return conferenceInfos;
    }

    public void setConferenceInfos(DefaultConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Override
    public String getType() {
        return EventNames.OWN_USER_INVITED;
    }
}
