package com.voxeet.sdk.core.network.endpoints;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;

public interface ISdkFilePresentationRService {

    @Multipart
    @POST("v1/files/convert")
    Call<ResponseBody> convertFile(
            @Part("description") RequestBody description,
            @Part MultipartBody.Part file);

    @POST("/v1/conferences/{confId}/filepresentation/start")
    Call<ResponseBody> startFilePresentation(@Path("confId") String conferenceId,
                                             @Body FilePresentationId body);


    @POST("/v1/conferences/{confId}/filepresentation/stop")
    Call<ResponseBody> stopFilePresentation(@Path("confId") String conferenceId,
                                                            @Body FilePresentationId body);


    @POST("/v1/conferences/{confId}/filepresentation/update")
    Call<ResponseBody> updateFilePresentation(@Path("confId") String conferenceId,
                                                              @Body FilePresentationId body);


    public class FilePresentationId {
        @NonNull
        public String fileId;

        @Nullable
        public String title;

        public int position;

        public int imageCount;

        private FilePresentationId() {

        }

        public FilePresentationId(String file_id) {
            fileId = file_id;
        }

        public FilePresentationId(String file_id, String title,
                                  int position, int imageCount) {
            fileId = file_id;
            this.title = title;
            this.position = position;
            this.imageCount = imageCount;
        }

        public FilePresentationId(String fileId, int position) {
            this(fileId);
            this.position = position;
        }
    }
}
