package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.abs.ConferenceSdkObservableProvider;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.success.ConferenceUsersInvitedEvent;
import com.voxeet.sdk.events.success.GetConferenceStatusEvent;
import com.voxeet.sdk.models.ConferenceUserStatus;
import com.voxeet.sdk.models.abs.ConferenceUser;
import com.voxeet.sdk.utils.ConferenceUtils;

import org.greenrobot.eventbus.EventBus;

import java.util.List;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import retrofit2.Call;
import retrofit2.Response;

public class GetConferenceStatus extends AbstractPromiseable<ConferenceUsersInvitedEvent> {

    public GetConferenceStatus(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<ConferenceUsersInvitedEvent> createPromise() {
        return new Promise<>(new PromiseSolver<ConferenceUsersInvitedEvent>() {
            @Override
            public void onCall(@NonNull final Solver<ConferenceUsersInvitedEvent> solver) {
                final Call<GetConferenceStatusEvent> user = getProvider().getConferenceStatusObservable(getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<GetConferenceStatusEvent>() {
                    @Override
                    public void onSuccess(@NonNull GetConferenceStatusEvent object, @NonNull Response<GetConferenceStatusEvent> response) {
                        List<ConferenceUser> users = ConferenceUtils.getUserInState(object.getConferenceUsers(), ConferenceUserStatus.CONNECTING);

                        log("Successfully retrieved connecting users");

                        ConferenceUsersInvitedEvent event = new ConferenceUsersInvitedEvent(users);
                        getEventBus().post(event);
                        solver.resolve(event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<GetConferenceStatusEvent> response) {
                        HttpException.dumpErrorResponse(response);

                        log("Error while retrieving connecting users");

                        getEventBus().post(new ConferenceUsersInvitedEvent(null));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}
