/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;

public final class AndroidManifest {
    private static final String TAG = AndroidManifest.class.getSimpleName();

    private AndroidManifest() {
    }

    public static int readMetadataInt(@NonNull Context context, @NonNull String key, int argb) {
        try {
            String metaData = AndroidManifest.readMetadata(context, key, null);
            if (!TextUtils.isEmpty((CharSequence)metaData)) {
                return Integer.parseInt(metaData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return argb;
    }

    public static String readMetadata(@NonNull Context context, @NonNull String key, @NonNull String def) {
        block8: {
            ApplicationInfo appInfo = null;
            try {
                appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                Bundle bundle = appInfo.metaData;
                String value = "";
                Log.d((String)TAG, (String)("readMetadata: checking for " + key));
                if (bundle.containsKey(key)) {
                    Object object = bundle.get(key);
                    Log.d((String)TAG, (String)("readMetadata: object ? " + object));
                    if (null != object) {
                        Log.d((String)TAG, (String)("readMetadata: klass := " + object.getClass().getSimpleName()));
                        if (object instanceof Integer) {
                            int resource = bundle.getInt(key);
                            value = context.getString(resource);
                        } else if (object instanceof String) {
                            value = (String)object;
                        }
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)value)) {
                    return value;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                String message = e.getMessage();
                if (null == message) break block8;
                Log.d((String)TAG, (String)("readMetadata: " + e.getMessage()));
            }
        }
        return def;
    }
}

