/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.camera.CameraInformationProvider;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.abs.information.ConferenceUserType;
import com.voxeet.sdk.core.http.HttpCallback;
import com.voxeet.sdk.core.http.HttpHelper;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.PermissionRefusedEvent;
import com.voxeet.sdk.events.promises.PromisePermissionRefusedEventException;
import com.voxeet.sdk.events.success.StartVideoAnswerEvent;
import com.voxeet.sdk.json.StartVideoResponse;
import com.voxeet.sdk.utils.Validate;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class StartVideoPromise
extends AbstractPromiseable<Boolean> {
    private static final String TAG = StartVideoPromise.class.getSimpleName();
    private final boolean isDefaultFrontFacing;

    public StartVideoPromise(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, boolean isDefaultFrontFacing) {
        super(parent, mediaService, provider, information, eventBus);
        this.isDefaultFrontFacing = isDefaultFrontFacing;
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                final ConferenceInformation information = StartVideoPromise.this.getInformation();
                try {
                    String defaultCameraName;
                    CameraInformationProvider provider = StartVideoPromise.this.getMediaService().getCameraInformationProvider();
                    provider.setDefaultCameraFront(StartVideoPromise.this.isDefaultFrontFacing);
                    StartVideoPromise.this.log("starting video");
                    if (!Validate.hasCameraPermissions(StartVideoPromise.this.getParent().getContext())) {
                        PermissionRefusedEvent event = new PermissionRefusedEvent(PermissionRefusedEvent.Permission.CAMERA);
                        StartVideoPromise.this.getEventBus().post((Object)event);
                        throw new PromisePermissionRefusedEventException(event);
                    }
                    if (!StartVideoPromise.this.getMediaService().hasMedia()) {
                        Log.d((String)TAG, (String)"startVideo: media is null");
                        throw new MediaEngineException("Media is null, invalid state");
                    }
                    if (null == information) {
                        Log.d((String)TAG, (String)"startVideo: information is null");
                        throw new MediaEngineException("ConferenceInformation is null, invalid state");
                    }
                    if (information.isOwnVideoStarted()) {
                        Log.d((String)TAG, (String)"startVideo: already started... please wait if you wanted to stop");
                        solver.resolve((Object)true);
                        return;
                    }
                    if (ConferenceUserType.LISTENER.equals((Object)information.getConferenceUserType())) {
                        Log.d((String)TAG, (String)"startVideo: you are a listener, you can't start the video");
                        solver.resolve((Object)false);
                        return;
                    }
                    String string2 = defaultCameraName = StartVideoPromise.this.isDefaultFrontFacing ? provider.getFrontCameraName() : provider.getBackCameraName();
                    if (null == defaultCameraName) {
                        throw new MediaEngineException("DefaultCamera is null, invalid state");
                    }
                    information.setOwnVideoStarted(true);
                    StartVideoPromise.this.getMediaService().getMedia().startVideo(defaultCameraName);
                    Call<StartVideoResponse> startVideo = StartVideoPromise.this.getProvider().getStartVideoObservable(StartVideoPromise.this.getInformation().getConference().getConferenceId(), VoxeetPreferences.id());
                    HttpHelper.enqueue(startVideo, new HttpCallback<StartVideoResponse>(){

                        @Override
                        public void onSuccess(@NonNull StartVideoResponse object, @NonNull Response<StartVideoResponse> response) {
                            StartVideoPromise.this.getInformation().setOwnVideoStarted(true);
                            StartVideoAnswerEvent event = new StartVideoAnswerEvent(true);
                            StartVideoPromise.this.getEventBus().post((Object)event);
                            StartVideoPromise.this.createVideoAnswer(object.getUserId(), object.getDescription(), object.getCandidates()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    error.printStackTrace();
                                    solver.resolve((Object)true);
                                }
                            });
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<StartVideoResponse> response) {
                            HttpException.dumpErrorResponse(response);
                            e.printStackTrace();
                            information.setOwnVideoStarted(false);
                            StartVideoAnswerEvent event = new StartVideoAnswerEvent(false);
                            StartVideoPromise.this.getEventBus().post((Object)event);
                            solver.reject(e);
                        }
                    });
                }
                catch (PromisePermissionRefusedEventException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (MediaEngineException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (Exception exception) {
                    solver.reject((Throwable)exception);
                }
            }
        });
    }
}

