/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.abs.information.ConferenceState;
import com.voxeet.sdk.core.abs.information.LocalConferenceType;
import com.voxeet.sdk.core.http.HttpCallback;
import com.voxeet.sdk.core.http.HttpHelper;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.ConferenceCreatedError;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.success.ConferenceCreatingEvent;
import com.voxeet.sdk.json.CreateConferenceParams;
import com.voxeet.sdk.json.internal.MetadataHolder;
import com.voxeet.sdk.json.internal.ParamsHolder;
import com.voxeet.sdk.models.ConferenceResponse;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class CreateConferencePromiseable
extends AbstractPromiseable<ConferenceResponse> {
    private String conferenceAlias;
    private MetadataHolder metadata;
    private ParamsHolder params = null;

    public CreateConferencePromiseable(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @Nullable String conferenceAlias, @Nullable MetadataHolder metadata, @Nullable ParamsHolder params) {
        super(parent, mediaService, provider, information, eventBus);
        this.conferenceAlias = conferenceAlias;
        this.metadata = metadata;
        this.params = params;
    }

    @Override
    @NonNull
    public Promise<ConferenceResponse> createPromise() {
        final Promise promise = new Promise((PromiseSolver)new PromiseSolver<ConferenceResponse>(){

            public void onCall(@NonNull Solver<ConferenceResponse> solver) {
                CreateConferencePromiseable.this.getEventBus().post((Object)new ConferenceCreatingEvent(CreateConferencePromiseable.this.conferenceAlias, null));
                CreateConferencePromiseable.this.log("Attempting to create mConferene alias:=" + CreateConferencePromiseable.this.conferenceAlias);
                CreateConferenceParams arg = new CreateConferenceParams().setMetadataHolder(CreateConferencePromiseable.this.metadata).setParamsHolder(CreateConferencePromiseable.this.params);
                if (null != CreateConferencePromiseable.this.conferenceAlias) {
                    arg.setConferenceAlias(CreateConferencePromiseable.this.conferenceAlias);
                }
                CreateConferencePromiseable.this.internalCreate(true, arg, (Solver<ConferenceResponse>)solver);
            }
        });
        if (this.getVoxeetSDK().isSocketOpen()) {
            return promise;
        }
        return new Promise((PromiseSolver)new PromiseSolver<ConferenceResponse>(){

            public void onCall(final @NonNull Solver<ConferenceResponse> solver) {
                CreateConferencePromiseable.this.getVoxeetSDK().logCurrentlySelectedUserWithChain().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                    public void onCall(@Nullable Boolean result, @NonNull Solver internal_solver) {
                        promise.then((PromiseExec)new PromiseExec<ConferenceResponse, Object>(){

                            public void onCall(@Nullable ConferenceResponse result, @NonNull Solver<Object> internal_solver) {
                                solver.resolve((Object)result);
                            }
                        }).error(new ErrorPromise(){

                            public void onError(@NonNull Throwable error) {
                                solver.reject(error);
                            }
                        });
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable error) {
                        solver.reject(error);
                    }
                });
            }
        });
    }

    private void internalCreate(final boolean retry, final CreateConferenceParams params, final Solver<ConferenceResponse> solver) {
        Call<ConferenceResponse> observable = this.getProvider().getCreateConferenceObservable(params);
        HttpHelper.enqueue(observable, new HttpCallback<ConferenceResponse>(){

            @Override
            public void onSuccess(@NonNull ConferenceResponse object, @NonNull Response<ConferenceResponse> response) {
                CreateConferencePromiseable.this.log("onNext: having conference");
                ConferenceInformation information = CreateConferencePromiseable.this.createOrSetConferenceWithParams(object.getConfId(), object.getConfAlias());
                information.setConferenceState(ConferenceState.CREATED);
                information.setConferenceType(LocalConferenceType.CONFERENCE);
                CreateConferencePromiseable.this.log("internalCreate onNext: join with := " + object.getConfId() + " " + object.getConfAlias());
                information.getConference().setConferenceId(object.getConfId());
                CreateConferencePromiseable.this.log("now conference is " + information.getConference().getConferenceId());
                solver.resolve((Object)object);
            }

            @Override
            public void onFailure(@NonNull Throwable e, @Nullable Response<ConferenceResponse> response) {
                HttpException.dumpErrorResponse(response);
                e.printStackTrace();
                if (!retry) {
                    CreateConferencePromiseable.this.log("internalCreate onFailure: conference creation failed ! but no retry... quit...");
                    CreateConferencePromiseable.this.setIsInConference(false);
                    CreateConferencePromiseable.this.closeMedia();
                    CreateConferencePromiseable.this.getEventBus().post((Object)new ConferenceCreatedError(CreateConferencePromiseable.this.getParent().handleError(e)));
                    solver.reject(e);
                } else {
                    CreateConferencePromiseable.this.log("internalCreate onFailure: conference creation failed ! but retry... now...");
                    CreateConferencePromiseable.this.internalCreate(false, params, (Solver<ConferenceResponse>)solver);
                }
            }
        });
    }
}

