/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.camera;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.camera.CameraInformationProvider;
import org.webrtc.Camera1Enumerator;

public class CameraEnumeratorPreLollipopWrapper
extends CameraInformationProvider<Camera1Enumerator> {
    private boolean checkedDevices = false;
    private String frontName;
    private String backName;

    public CameraEnumeratorPreLollipopWrapper(@NonNull Context context) {
        super(new Camera1Enumerator(false));
        this.checkForDevices();
        this.setDefaultCameraFront(true);
    }

    @Override
    @Nullable
    public String getFrontCameraName() {
        this.checkForDevices();
        return this.frontName;
    }

    @Override
    @Nullable
    public String getBackCameraName() {
        this.checkForDevices();
        return this.backName;
    }

    private void checkForDevices() {
        if (!this.checkedDevices) {
            String[] names = this.getDevicesName();
            if (names.length > 0) {
                for (String name : names) {
                    if (((Camera1Enumerator)this.getEnumerator()).isFrontFacing(name)) {
                        this.frontName = name;
                        continue;
                    }
                    if (!((Camera1Enumerator)this.getEnumerator()).isBackFacing(name)) continue;
                    this.backName = name;
                }
            }
            this.checkedDevices = true;
        }
    }
}

