package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.TimeZone;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.SOCIAL_LOGIN)
public class SocialLoginEvent extends Event {

    @JsonIgnore
    private final String FB = "FACEBOOK";

    @JsonIgnore
    private final String GOOGLE = "GOOGLE";

    @JsonIgnore
    private final String SLACK = "SLACK";

    @JsonProperty("external_network")
    private String externalNetwork;

    private String timezone;

    @JsonProperty("access_token")
    private String accessToken;

    @JsonProperty("push_token")
    private String devicePushToken;

    @JsonProperty("device_type")
    private String deviceType;

    @JsonProperty("device_identifier")
    private String deviceIdentifier;

    public SocialLoginEvent(String externalNetwork, String accessToken,  String devicePushToken, String deviceIdentifier) {

        this.externalNetwork = externalNetwork;

        this.timezone = TimeZone.getDefault().getID();

        this.devicePushToken = devicePushToken;

        this.deviceType = "ANDROID";

        this.accessToken = accessToken;

        this.deviceIdentifier = deviceIdentifier;
    }

    public String getDevicePushToken() {
        return devicePushToken;
    }

    public void setDevicePushToken(String devicePushToken) {
        this.devicePushToken = devicePushToken;
    }

    public String getDeviceIdentifier() {
        return deviceIdentifier;
    }

    public void setDeviceIdentifier(String deviceIdentifier) {
        this.deviceIdentifier = deviceIdentifier;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getExternalNetwork() {
        return externalNetwork;
    }

    public void setExternalNetwork(String externalNetwork) {
        this.externalNetwork = externalNetwork;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getTimezone() {
        return timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Override
    public String getType() {
        return EventNames.SOCIAL_LOGIN;
    }
}
