package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.impl.DefaultUserProfile;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.CONTACT_PROFILE_UPDATED)
public class ProfileUpdatedEvent extends Event{

    DefaultUserProfile profile;

    public DefaultUserProfile getProfile() {
        return profile;
    }

    public void setProfile(DefaultUserProfile profile) {
        this.profile = profile;
    }

    @Override
    public String getType() {
        return EventNames.CONTACT_PROFILE_UPDATED;
    }
}
