package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Sha1;

import java.util.TimeZone;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.LOGIN)
public class LoginEvent extends Event {

    private String login;

    private String password;

    private String timezone;

    private String devicePushToken;

    private String deviceType;

    private String deviceIdentifier;

    public LoginEvent(String login, String password, String devicePushToken, String deviceIdentifier) {
        this.login = login;

        this.password = Sha1.compute(password);

        this.timezone = TimeZone.getDefault().getID();

        this.devicePushToken = devicePushToken;

        this.deviceType = "ANDROID";

        this.deviceIdentifier = deviceIdentifier;
    }

    public String getDevicePushToken() {
        return devicePushToken;
    }

    public void setDevicePushToken(String devicePushToken) {
        this.devicePushToken = devicePushToken;
    }

    public String getDeviceIdentifier() {
        return deviceIdentifier;
    }

    public void setDeviceIdentifier(String deviceIdentifier) {
        this.deviceIdentifier = deviceIdentifier;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTimezone() {
        return timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Override
    public String getType() {
        return EventNames.LOGIN;
    }
}
