package com.voxeet.sdk.events.success;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.json.ParticipantUpdated;

public class ParticipantUpdatedEvent extends SuccessEvent {

    private String confId;

    private String userId;

    private String status;

    public ParticipantUpdatedEvent(String message, ParticipantUpdated event) {
        this.setMessage(message);

        this.confId = event.getConferenceId();

        this.userId = event.getUserId();

        this.status = event.getStatus();
    }

    public String getConfId() {
        return confId;
    }

    public void setConfId(String confId) {
        this.confId = confId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}
