package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.http.HttpCallback;
import com.voxeet.sdk.core.http.HttpHelper;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.GetConferenceStatusErrorEvent;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.PromiseGetConferenceStatusErrorEventException;
import com.voxeet.sdk.events.success.GetConferenceStatusEvent;
import com.voxeet.sdk.models.abs.ConferenceUser;

import org.greenrobot.eventbus.EventBus;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import retrofit2.Call;
import retrofit2.Response;

public class GetConferenceStatusPromiseable  extends AbstractPromiseable<GetConferenceStatusEvent> {

    public GetConferenceStatusPromiseable(@NonNull ConferenceService parent,
                                          @NonNull MediaService mediaService,
                                          @NonNull AbstractConferenceSdkObservableProvider provider,
                                          @Nullable ConferenceInformation information,
                                          @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<GetConferenceStatusEvent> createPromise() {
        return new Promise<>(new PromiseSolver<GetConferenceStatusEvent>() {
            @Override
            public void onCall(@NonNull final Solver<GetConferenceStatusEvent> solver) {
                final Call<GetConferenceStatusEvent> user = getProvider().getConferenceStatusObservable(getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpCallback<GetConferenceStatusEvent>() {
                    @Override
                    public void onSuccess(@NonNull GetConferenceStatusEvent object, @NonNull Response<GetConferenceStatusEvent> response) {
                        try {
                            if (null != response && null != object.getConferenceUsers()) {
                                for (ConferenceUser conferenceUser : object.getConferenceUsers()) {
                                    log(conferenceUser.getUserId() + " / " + conferenceUser.getStatus());
                                }
                                log("Dispatching mConference status result");
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                        getEventBus().post(object);
                        solver.resolve(object);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<GetConferenceStatusEvent> response) {
                        HttpException.dumpErrorResponse(response);

                        log("Error while getting mConference history");
                        e.printStackTrace();

                        try {
                            GetConferenceStatusErrorEvent event = new GetConferenceStatusErrorEvent(getParent().handleError(e));
                            getEventBus().post(event);
                            throw new PromiseGetConferenceStatusErrorEventException(event, e);
                        } catch (PromiseGetConferenceStatusErrorEventException exception) {
                            solver.reject(exception);
                        }
                    }
                });
            }
        });
    }
}
