/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.voxeet.sdk.models.MeetingAttributes;
import com.voxeet.sdk.models.abs.MeetingEvent;
import com.voxeet.sdk.models.impl.DefaultUserProfile;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DefaultMeetingEvent
implements MeetingEvent,
Comparable<DefaultMeetingEvent> {
    private static final String TAG = DefaultMeetingEvent.class.getSimpleName();
    @JsonProperty(value="evtUser")
    private DefaultUserProfile owner;
    private String meetingId;
    private String meetingEventId;
    private String meetingEventType;
    @JsonProperty(value="timestamp")
    private long time;
    private boolean notification;
    private MeetingAttributes attributes;
    @JsonIgnore
    private boolean hasGroupDate;

    @Override
    public MeetingAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(MeetingAttributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public DefaultUserProfile getOwner() {
        return this.owner;
    }

    @Override
    public boolean hasGroupDate() {
        return this.hasGroupDate;
    }

    @Override
    public void setHasGroupDate(boolean hasGroupDate) {
        this.hasGroupDate = hasGroupDate;
    }

    public void setOwner(DefaultUserProfile owner) {
        this.owner = owner;
    }

    @Override
    public String getMeetingId() {
        return this.meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    @Override
    public String getMeetingEventId() {
        return this.meetingEventId;
    }

    public void setMeetingEventId(String meetingEventId) {
        this.meetingEventId = meetingEventId;
    }

    @Override
    public MeetingEvent.Type getMeetingEventType() {
        return MeetingEvent.Type.valueOf(this.meetingEventType);
    }

    public void setMeetingEventType(String meetingEventType) {
        this.meetingEventType = meetingEventType;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isNotification() {
        return this.notification;
    }

    public void setNotification(boolean notification) {
        this.notification = notification;
    }

    @Override
    public int compareTo(DefaultMeetingEvent another) {
        return new Date(another.getTime()).compareTo(new Date(this.getTime()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMeetingEvent event = (DefaultMeetingEvent)o;
        return this.meetingEventId != null ? this.meetingEventId.equalsIgnoreCase(event.meetingEventId) : event.meetingEventId == null;
    }

    public int hashCode() {
        return this.meetingEventId != null ? this.meetingEventId.hashCode() : 0;
    }

    public String toString() {
        return this.meetingEventId;
    }
}

