/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.utils.Sha1;
import java.util.Locale;
import java.util.TimeZone;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="SignUp")
public class SignUpEvent
extends Event {
    private String bytePassword;
    private String email;
    private String country;
    private String company;
    private String deviceType;
    private String password;
    private String nickName;
    private String firstName;
    private String lastName;
    private String timezone;
    private String locale;

    public SignUpEvent(String email, String password, String firstName, String lastName) {
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
        this.nickName = firstName + " " + lastName;
        this.nickName = firstName + " " + lastName;
        this.bytePassword = this.password = Sha1.compute(password);
        this.deviceType = "ANDROID";
        this.locale = Locale.getDefault().toString();
        this.timezone = TimeZone.getDefault().getID();
        this.country = Locale.getDefault().getCountry();
        this.company = null;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getBytePassword() {
        return this.bytePassword;
    }

    public void setBytePassword(String bytePassword) {
        this.bytePassword = bytePassword;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public String getType() {
        return "SignUp";
    }
}

