/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaSDK;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetHttp;
import com.voxeet.sdk.core.VoxeetWebSocket;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.AudioService;
import com.voxeet.sdk.core.services.LocalStatsService;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.core.services.ScreenShareService;
import com.voxeet.sdk.core.services.UserService;
import com.voxeet.sdk.core.services.authenticate.WebSocketState;
import com.voxeet.sdk.core.services.authenticate.token.RefreshTokenCallback;
import com.voxeet.sdk.events.error.SocketConnectErrorEvent;
import com.voxeet.sdk.events.success.SocketConnectEvent;
import com.voxeet.sdk.events.success.SocketStateChangeEvent;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.exceptions.VoxeetSentry;
import com.voxeet.sdk.factories.EventsFactory;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.OkHttpClient;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.EventBusException;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import retrofit2.Retrofit;

public abstract class VoxeetSdkTemplate {
    static final long DEFAULT_TIMEOUT_MS = 60000L;
    private static final String TAG = "VoxeetSdk";
    private UserInfo _user_info;
    private VoxeetWebSocket _voxeet_websocket;
    private VoxeetHttp _voxeet_http;
    protected Context _application_context;
    protected EventBus _event_bus;
    private AbstractVoxeetEnvironmentHolder _voxeet_environment_holder;
    private HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> _services;
    private List<Solver<Boolean>> mWaitForLogInSocket;
    private ReentrantLock lockConnectAttempt = new ReentrantLock();
    private VoxeetSentry voxeetSentry;

    private VoxeetSdkTemplate() {
    }

    protected VoxeetSdkTemplate(@NonNull Application application_context, @NonNull String appId, @NonNull String password, @NonNull UserInfo userInfo, @NonNull AbstractVoxeetEnvironmentHolder holder, boolean debug) {
        this(application_context, appId, password, userInfo, null, null, holder, debug);
    }

    protected VoxeetSdkTemplate(@NonNull Application application_context, @NonNull String tokenAccess, @Nullable RefreshTokenCallback tokenRefresh, @NonNull UserInfo userInfo, @NonNull AbstractVoxeetEnvironmentHolder holder, boolean debug) {
        this(application_context, null, null, userInfo, tokenAccess, tokenRefresh, holder, debug);
    }

    private VoxeetSdkTemplate(@NonNull Application application_context, @Nullable String appId, @Nullable String password, @NonNull UserInfo userInfo, @Nullable String tokenAccess, @Nullable RefreshTokenCallback tokenRefresh, @NonNull AbstractVoxeetEnvironmentHolder holder, boolean debug) {
        this();
        this.initExceptionIfOk(application_context);
        this.mWaitForLogInSocket = new ArrayList<Solver<Boolean>>();
        this._application_context = application_context;
        this._event_bus = EventBus.getDefault();
        Promise.setHandler((Handler)new Handler(Looper.getMainLooper()));
        this._user_info = userInfo;
        Log.d((String)"VoxeetSDK", (String)("VoxeetSdkTemplate: version := " + holder.getVersionName()));
        this._voxeet_environment_holder = holder;
        this._voxeet_websocket = new VoxeetWebSocket(this, this._voxeet_environment_holder.getSocketUrl());
        VoxeetHttp.Builder builder = new VoxeetHttp.Builder().setApplication(application_context).setVoxeetSDK(this).setServerUrl(this._voxeet_environment_holder.getServerUrl()).setServerPort(this._voxeet_environment_holder.getServerPort()).setAppId(appId).setPassword(password).setTokenAccess(tokenAccess).setTokenRefresh(tokenRefresh).setVoxeetServiceListener(new VoxeetHttp.VoxeetServiceListener(){

            @Override
            public void onIdentifySuccess(VoxeetHttp provider) {
                VoxeetSdkTemplate.this._voxeet_websocket.connect(provider);
            }

            @Override
            public void onIdentifyError(String error) {
                if (null == error) {
                    error = "identfify error";
                }
                Log.e((String)VoxeetSdkTemplate.this.getTag(), (String)error);
                VoxeetSdkTemplate.this._event_bus.post((Object)new SocketStateChangeEvent(WebSocketState.CLOSED.name()));
            }

            @Override
            public void onNetworkError(UnknownHostException error) {
                VoxeetSdkTemplate.this._event_bus.post((Object)new SocketStateChangeEvent(WebSocketState.CLOSED.name()));
            }
        }).setDebug(debug);
        this._voxeet_http = builder.build();
        this._services = new HashMap();
        if (!this._event_bus.isRegistered((Object)this)) {
            this._event_bus.register((Object)this);
        }
        VoxeetPreferences.init(this.getApplicationContext(), this.getVoxeetEnvironmentHolder());
        this.initServices();
    }

    private void initExceptionIfOk(@NonNull Application application_context) {
        Log.d((String)TAG, (String)"initExceptionIfOk: checking for exception to log internally");
        this.voxeetSentry = new VoxeetSentry((Context)application_context);
        ExceptionManager.register(this.voxeetSentry);
        Log.d((String)TAG, (String)"initExceptionIfOk: finished to try implementing error management");
    }

    public void resetVoxeetHttp() {
        this._voxeet_http.resetVoxeetHttp();
    }

    @Deprecated
    public void logUser(@NonNull UserInfo userInfo) {
        this._user_info = userInfo;
        this.logUserWithChain(userInfo).then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)VoxeetSdkTemplate.TAG, (String)"onCall: deprecated logUser method finished");
            }
        }).error(new ErrorPromise(){

            public void onError(@NonNull Throwable error) {
                error.printStackTrace();
            }
        });
    }

    public Promise<Boolean> logUserWithChain(@NonNull UserInfo userInfo) {
        this._user_info = userInfo;
        return this.logCurrentlySelectedUserWithChain();
    }

    public Promise<Boolean> logCurrentlySelectedUserWithChain() {
        if (this.isSocketOpen()) {
            return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

                public void onCall(@NonNull Solver<Boolean> solver) {
                    Log.d((String)VoxeetSdkTemplate.TAG, (String)"onCall: socket opened");
                    VoxeetSdkTemplate.this.lockConnectAttempt();
                    VoxeetSdkTemplate.this.resolveLoginSockets();
                    VoxeetSdkTemplate.this.unlockConnectAttempt();
                    solver.resolve((Object)true);
                }
            });
        }
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(@NonNull Solver<Boolean> solver) {
                if (null != VoxeetSdkTemplate.this._voxeet_websocket && VoxeetSdkTemplate.this.isSocketOpen()) {
                    VoxeetSdkTemplate.this._voxeet_websocket.close(true);
                }
                Log.d((String)VoxeetSdkTemplate.TAG, (String)"onCall: start login in promise");
                VoxeetSdkTemplate.this.lockConnectAttempt();
                Log.d((String)VoxeetSdkTemplate.TAG, (String)("onCall: having the list with elements := " + VoxeetSdkTemplate.this.mWaitForLogInSocket));
                if (VoxeetSdkTemplate.this.mWaitForLogInSocket.size() == 0) {
                    VoxeetSdkTemplate.this.mWaitForLogInSocket.add(solver);
                    VoxeetSdkTemplate.this.unlockConnectAttempt();
                    VoxeetSdkTemplate.this.openSdkSessionChain().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                        public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                            Log.d((String)VoxeetSdkTemplate.TAG, (String)"onCall: first login part done");
                        }
                    }).error(new ErrorPromise(){

                        public void onError(@NonNull Throwable error) {
                            Log.d((String)VoxeetSdkTemplate.TAG, (String)("onError: login error " + error.getMessage()));
                            VoxeetSdkTemplate.this.lockConnectAttempt();
                            VoxeetSdkTemplate.this.rejectLoginSockets(error);
                            VoxeetSdkTemplate.this.clearLoginSockets();
                            VoxeetSdkTemplate.this.unlockConnectAttempt();
                            Log.d((String)VoxeetSdkTemplate.TAG, (String)"onError: login error managed");
                        }
                    });
                } else {
                    Log.d((String)VoxeetSdkTemplate.TAG, (String)"onCall: already have a login attempt in progress");
                    try {
                        throw new IllegalStateException("Can not open a session while an other one is trying to be started");
                    }
                    catch (Exception e) {
                        solver.reject((Throwable)e);
                        VoxeetSdkTemplate.this.unlockConnectAttempt();
                    }
                }
                Log.d((String)VoxeetSdkTemplate.TAG, (String)"onCall: start login done... can take a time");
            }
        });
    }

    protected abstract void initServices();

    protected HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> getServices() {
        return this._services;
    }

    public ConferenceService getConferenceService() {
        return this.getServiceForKlass(ConferenceService.class);
    }

    public ScreenShareService getScreenShareService() {
        return this.getServiceForKlass(ScreenShareService.class);
    }

    public AudioService getAudioService() {
        return this.getServiceForKlass(AudioService.class);
    }

    <T extends AbstractVoxeetService> T getServiceForKlass(Class<T> klass) {
        AbstractVoxeetService service = null;
        for (Class<? extends AbstractVoxeetService> next : this._services.keySet()) {
            AbstractVoxeetService item = this._services.get(next);
            if (!klass.isInstance(item)) continue;
            service = item;
        }
        if (service == null) {
            Log.d((String)TAG, (String)(klass.getSimpleName() + " not found in the list of services"));
        }
        return (T)service;
    }

    public void getUploadToken() {
        UserService service = this.getServiceForKlass(UserService.class);
        if (service != null) {
            service.getUploadToken();
        }
    }

    public Event decode(String message) {
        return EventsFactory.decode(message);
    }

    public Retrofit getRetrofit() {
        return this._voxeet_http.getRetrofit();
    }

    public OkHttpClient getClient() {
        return this._voxeet_http.getClient();
    }

    public Context getApplicationContext() {
        return this._application_context;
    }

    AbstractVoxeetEnvironmentHolder getVoxeetEnvironmentHolder() {
        return this._voxeet_environment_holder;
    }

    public void resetServices() {
        for (Class<? extends AbstractVoxeetService> next : this._services.keySet()) {
            AbstractVoxeetService service = this._services.get(next);
            if (null == service) continue;
            service.resetService();
        }
    }

    public EventBus getEventBus() {
        return this._event_bus;
    }

    protected VoxeetWebSocket getSocket() {
        return this._voxeet_websocket;
    }

    VoxeetHttp getVoxeetHttp() {
        return this._voxeet_http;
    }

    public void closeSocket() {
        this._voxeet_websocket.close(true);
    }

    public void cleanUserSession(@NonNull String id) {
        this._voxeet_http.cleanUserSession(id);
    }

    public boolean isSocketOpen() {
        return this._voxeet_websocket.isOpen();
    }

    public void openSdkSession() {
        this._voxeet_http.identify(this._user_info);
    }

    private Promise<Boolean> openSdkSessionChain() {
        return this._voxeet_http.identifyChain(this._user_info);
    }

    public UserInfo getUserInfo() {
        return this._user_info;
    }

    protected abstract String getTag();

    public boolean register(@NonNull Context context) {
        return this.register(context, null);
    }

    public boolean register(@NonNull Context context, @Nullable Object subscriber) {
        try {
            MediaSDK.setContext(context);
            if (null != subscriber && !this.getEventBus().isRegistered(subscriber)) {
                this.getEventBus().register(subscriber);
            }
        }
        catch (EventBusException eventBusException) {
        }
        catch (UnsatisfiedLinkError error) {
            return false;
        }
        return true;
    }

    public void unregister(@NonNull Object subscriber) {
        if (this.getEventBus().isRegistered(subscriber)) {
            this.getEventBus().unregister(subscriber);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(SocketConnectEvent event) {
        Log.d((String)TAG, (String)"onEvent: ");
        this.lockConnectAttempt();
        this.resolveLoginSockets();
        this.unlockConnectAttempt();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(SocketConnectErrorEvent event) {
        this.lockConnectAttempt();
        for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
            Log.d((String)TAG, (String)"onEvent: calling resolved false");
            Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
            try {
                solver.resolve((Object)false);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.clearLoginSockets();
        this.unlockConnectAttempt();
    }

    @NonNull
    public MediaService getMediaService() {
        return this.getServiceForKlass(MediaService.class);
    }

    @NonNull
    public LocalStatsService getLocalStatsService() {
        return this.getServiceForKlass(LocalStatsService.class);
    }

    void lockConnectAttempt() {
        try {
            this.lockConnectAttempt.lock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void unlockConnectAttempt() {
        try {
            if (this.lockConnectAttempt.isLocked()) {
                this.lockConnectAttempt.unlock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void rejectLoginSockets(@Nullable Throwable error) {
        try {
            for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
                Log.d((String)TAG, (String)"onError: calling reject");
                Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
                try {
                    solver.reject(error);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private void resolveLoginSockets() {
        try {
            for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
                Log.d((String)TAG, (String)"onEvent: calling resolved true");
                Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
                try {
                    solver.resolve((Object)true);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clearLoginSockets();
    }

    void clearLoginSockets() {
        try {
            this.mWaitForLogInSocket.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

