/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.audio;

import android.content.Context;
import android.media.Ringtone;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.MediaPowerManager;
import com.voxeet.audio.AudioRoute;
import com.voxeet.audio.AudioStackManager;
import com.voxeet.sdk.utils.AudioType;
import com.voxeet.sdk.utils.SoundPool;
import com.voxeet.sdk.utils.Validate;
import java.util.HashMap;
import java.util.List;

public class SoundManager {
    private AudioStackManager mAudioManager;
    private MediaPowerManager mMediaPowerManager;
    private Context mContext;
    private SoundPool _sound_pool;
    private HashMap<AudioType, String> mSounds;
    private boolean mEnable;

    private SoundManager() {
        this.enable();
    }

    public SoundManager(@NonNull Context context) {
        this();
        this.mAudioManager = new AudioStackManager(context);
        this.mAudioManager.configureVolumeStream(0, 3);
        this.mMediaPowerManager = new MediaPowerManager(context, this.currentRoute());
        this.mContext = context;
        this.mSounds = new HashMap();
        this.configure();
    }

    @NonNull
    public List<AudioRoute> getAvailableRoutes() {
        return this.mAudioManager.availableRoutes();
    }

    public AudioRoute currentRoute() {
        return this.mAudioManager.outputRoute();
    }

    public boolean setAudioRoute(@NonNull AudioRoute route) {
        Validate.runningOnUiThread();
        return this.mAudioManager.setOutputRoute(route);
    }

    @Nullable
    public Ringtone getSystemRingtone() {
        return this.mAudioManager.getSystemRingtone();
    }

    public boolean isBluetoothHeadsetConnected() {
        return this.mAudioManager.isBluetoothHeadsetConnected();
    }

    public boolean isWiredHeadsetOn() {
        return this.mAudioManager.isWiredHeadsetOn();
    }

    public SoundManager setSpeakerMode(boolean isSpeaker) {
        this.mAudioManager.setSpeakerMode(isSpeaker);
        return this;
    }

    public boolean isSpeakerOn() {
        return AudioRoute.ROUTE_SPEAKER.equals((Object)this.mAudioManager.outputRoute());
    }

    public SoundManager acquireLocks() {
        this.mMediaPowerManager.acquire();
        return this;
    }

    public SoundManager releaseLocks() {
        this.mMediaPowerManager.release();
        return this;
    }

    public SoundManager resetDefaultSoundType() {
        this.mAudioManager.resetDefaultSoundType();
        return this;
    }

    private int getUiSoundsStreamType() {
        return this.mAudioManager.getDefaultSoundStreamType();
    }

    private SoundManager forceVolumeControlStream(int type) {
        this.mAudioManager.forceVolumeControlStream(type);
        return this;
    }

    public SoundManager abandonAudioFocusRequest() {
        this.mAudioManager.abandonAudioFocus();
        return this;
    }

    public SoundManager requestAudioFocus() {
        this.mAudioManager.requestAudioFocus();
        return this;
    }

    public SoundManager checkOutputRoute() {
        this.mAudioManager.checkOutputRoute();
        return this;
    }

    private SoundPool getSoundPool() {
        if (this._sound_pool == null) {
            this._sound_pool = new SoundPool(this.mContext, 0);
        }
        return this._sound_pool;
    }

    private void configure() {
        this.mAudioManager.enable();
        this.mSounds.put(AudioType.RING, "out.mp3");
        this.mSounds.put(AudioType.HANGUP, "leave.mp3");
        this.setSound(AudioType.RING, this.mSounds.get((Object)AudioType.RING));
        this.setSound(AudioType.HANGUP, this.mSounds.get((Object)AudioType.HANGUP));
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName) {
        return this.getSoundPool().release(type).setShortResource(type, assetName);
    }

    public SoundManager playSoundType(@NonNull AudioType type) {
        if (this.isEnabled()) {
            this.getSoundPool().playShortResource(type, this.mSounds.get((Object)type));
        }
        return this;
    }

    public SoundManager playSoundTypeForce(@NonNull AudioType type) {
        this.getSoundPool().playShortResource(type, this.mSounds.get((Object)type));
        return this;
    }

    public SoundManager stopSoundType(@NonNull AudioType audioType) {
        this.getSoundPool().stop(audioType);
        return this;
    }

    public SoundManager stop() {
        this.getSoundPool().stop();
        return this;
    }

    public SoundManager onConferencePreJoinedEvent() {
        this.mAudioManager.checkOutputRoute();
        return this;
    }

    public SoundManager onConferenceDestroyedPush() {
        this.abandonAudioFocusRequest();
        return this;
    }

    public SoundManager enable() {
        this.mEnable = true;
        if (null != this.mAudioManager) {
            this.mAudioManager.enable();
        }
        return this;
    }

    public SoundManager disable() {
        this.mEnable = false;
        if (null != this.mAudioManager) {
            this.mAudioManager.disable();
        }
        return this;
    }

    private boolean isEnabled() {
        return this.mEnable;
    }
}

