package com.voxeet.sdk.models.abs;

import java.util.List;

import com.voxeet.sdk.models.impl.DefaultConferenceInfos;

public interface Meeting<UP extends UserProfile> {

    List<? extends MeetingEvent> getEvents();

    DefaultConferenceInfos getConferenceInfos();

    int getNbSharedFile();

    List<String> getTags();

    String getSettings();

    String getMeetingId();

    String getMeetingType();

    long getLastRead();

    List<UP> getProfiles();

    MeetingEvent lastEvent();

    String title();

    String name();

    void sort();

    boolean isObjectValid();

    MeetingEvent getLastMeetingEvent();
}
