package com.voxeet.sdk.models;

public enum ConferenceQuality {
    ULTRA_LOW("ULTRA_LOW"),
    LOW("LOW"),
    MEDIUM("MEDIUM"),
    HIGH("HIGH"),
    ULTRA_HIGH("ULTRA_HIGH");

    private final String value;

    private ConferenceQuality(String quality) {
        this.value = quality;
    }

    public int integerValue() {
        switch (value) {
            case "ULTRA_LOW":
                return 1;
            case "LOW":
                return 2;
            case "MEDIUM":
                return 3;
            case "HIGH":
                return 4;
            case "ULTRA_HIGH":
                return 5;
            default:
                return 3;
        }
    }

    public String StringValue() {
        return value;
    }

    public static ConferenceQuality fromString(String value) {
        switch (value) {
            case "ULTRA_LOW":
                return ULTRA_LOW;
            case "LOW":
                return LOW;
            case "MEDIUM":
                return MEDIUM;
            case "HIGH":
                return HIGH;
            case "ULTRA_HIGH":
                return ULTRA_HIGH;
            default:
                return MEDIUM;
        }
    }
}
