package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.OfferCandidate;
import com.voxeet.sdk.models.OfferDescription;

import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.STOP_VIDEO)
public class StopVideoResponse extends Event {

    @JsonProperty("candidates")
    private List<OfferCandidate> candidates;

    @JsonProperty("description")
    private OfferDescription description;

    @JsonProperty("user_id")
    private String userId;

    public StopVideoResponse() {
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<OfferCandidate> getCandidates() {
        return candidates;
    }

    public void setCandidates(List<OfferCandidate> candidates) {
        this.candidates = candidates;
    }

    public OfferDescription getDescription() {
        return description;
    }

    public void setDescription(OfferDescription description) {
        this.description = description;
    }

    @Override
    public String getType() {
        return EventNames.STOP_VIDEO;
    }
}
