package com.voxeet.sdk.core.services;

import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.network.IUserRService;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.events.error.GetUploadTokenErrorEvent;
import com.voxeet.sdk.events.error.NewLoginRequiredEvent;
import com.voxeet.sdk.events.success.GetTokenUploadSuccessEvent;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class UserService extends com.voxeet.sdk.core.AbstractVoxeetService<IUserRService> {

    /**
     * Instantiates a new User service.
     *
     * @param instance the parent instance
     */
    public UserService(VoxeetSdkTemplate instance) {
        super(instance, IUserRService.class);
    }

    /**
     * The interface User service listener.
     */
    public interface UserServiceListener {
        /**
         * On login success.
         *
         * @param id the id
         */
        void onLoginSuccess(String id);

        /**
         * On logout sucesss.
         */
        void onLogoutSucesss();
    }


    /**
     * Gets upload token.
     */
    public final void getUploadToken() {
        final Call<GetTokenUploadSuccessEvent> user = getService().getUploadToken();
        user.enqueue(new Callback<GetTokenUploadSuccessEvent>() {
            @Override
            public void onResponse(Call<GetTokenUploadSuccessEvent> call, Response<GetTokenUploadSuccessEvent> response) {
                if(response.isSuccessful()) {
                    getEventBus().post(response);

                    VoxeetPreferences.setUploadToken(response.body().getUploadToken());
                } else {
                    getEventBus().post(new NewLoginRequiredEvent("New login required"));
                }
            }

            @Override
            public void onFailure(Call<GetTokenUploadSuccessEvent> call, Throwable e) {
                getEventBus().post(new GetUploadTokenErrorEvent(handleError(e)));
            }
        });
    }
}