package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.http.HttpCallback;
import com.voxeet.sdk.core.http.HttpHelper;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.SubscribeConferenceErrorEvent;
import com.voxeet.sdk.events.success.SubscribeConferenceEvent;
import com.voxeet.sdk.models.SubscribeConference;

import org.greenrobot.eventbus.EventBus;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import retrofit2.Call;
import retrofit2.Response;

public class SubscribeConferenceEventPromiseable extends AbstractPromiseable<Boolean> {

    public SubscribeConferenceEventPromiseable(@NonNull ConferenceService parent,
                                               @NonNull MediaService mediaService,
                                               @NonNull AbstractConferenceSdkObservableProvider provider,
                                               @Nullable ConferenceInformation information,
                                               @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(new PromiseSolver<Boolean>() {
            @Override
            public void onCall(@NonNull final Solver<Boolean> solver) {
                final Call<SubscribeConference> user = getProvider().getSubscribeObservable(getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpCallback<SubscribeConference>() {
                    @Override
                    public void onSuccess(@NonNull SubscribeConference object, @NonNull Response<SubscribeConference> response) {
                        log("You are no subscribed to this mConference's events");

                        getEventBus().post(new SubscribeConferenceEvent(object));
                        solver.resolve(true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<SubscribeConference> response) {
                        HttpException.dumpErrorResponse(response);

                        log("Failed to subscribe to this mConference's events");

                        getEventBus().post(new SubscribeConferenceErrorEvent(getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}
