package com.voxeet.android.media.sensors;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.util.Log;

public class ProximitySensor implements ConferenceLock, SensorEventListener {
    private final static float NEAR = 0;
    private final static float FAR = 5;
    private static final String TAG ="Sensor";
    private PowerManager.WakeLock mScreenOn;
    private PowerManager.WakeLock mScreenOff;
    private Sensor mProximity;
    private SensorManager mSensorManager;
    private Context mContext;
    private boolean acquired;
    private float last = FAR;

    private ProximitySensor() {
        acquired = false;
    }

    public ProximitySensor(@NonNull Context context) {
        this();
        mContext = context;


        mSensorManager = (SensorManager) mContext.getSystemService(Context.SENSOR_SERVICE);
        if (null != mSensorManager) {
            mProximity = mSensorManager.getDefaultSensor(Sensor.TYPE_PROXIMITY);
        }

        PowerManager manager = ((PowerManager) mContext.getSystemService(Context.POWER_SERVICE));
        if (null != manager) {
            String t = TAG + ":";
            mScreenOn = manager.newWakeLock(PowerManager.SCREEN_BRIGHT_WAKE_LOCK | PowerManager.ACQUIRE_CAUSES_WAKEUP, t);
            mScreenOff = manager.newWakeLock(PowerManager.PROXIMITY_SCREEN_OFF_WAKE_LOCK, t);
        }
    }

    @Override
    public void acquire() {
        Log.d(TAG, "acquire: " + acquired+" ");
        if (!acquired && null != mSensorManager) {
            acquired = mSensorManager.registerListener(this, mProximity, SensorManager.SENSOR_DELAY_NORMAL);
        }
        Log.d(TAG, "acquire: now " + acquired+" ");
        updateLock();

    }

    @Override
    public void release() {
        if (acquired) {
            mSensorManager.unregisterListener(this);
            acquired = false;
        }
        last = FAR;
        releaseLocks();
    }

    @Override
    public boolean isProximity() {
        return true;
    }

    @Override
    public void onSensorChanged(SensorEvent event) {
        if (event.values.length >= 0) {
            last = event.values[0];
        }

        updateLock();
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {

    }

    private void updateLock() {
        try {
            if (last >= FAR) {
                if (mScreenOff.isHeld()) mScreenOff.release();
                mScreenOn.acquire();
            } else {
                if (mScreenOn.isHeld()) mScreenOn.release();
                mScreenOff.acquire();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void releaseLocks() {
        try {
            if (mScreenOn.isHeld()) mScreenOn.release();
            if (mScreenOff.isHeld()) mScreenOff.release();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
