package com.voxeet.android.media.camera;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.android.media.video.Camera2Enumerator;

public class CameraEnumeratorLollipopWrapper implements CameraEnumeratorWrapper {

    private Camera2Enumerator enumerator;

    private String defaultName;

    public CameraEnumeratorLollipopWrapper(Context context) {
        enumerator = new Camera2Enumerator(context);

        defaultName = enumerator.getNameOfFrontFacingDevice();

        if (null == defaultName) {
            defaultName = enumerator.getNameOfBackFacingDevice();
        }

        if(null == defaultName) {
            String[] names = enumerator.getDeviceNames();
            defaultName = null != names && names.length > 0 ? names[0] : null;
        }
    }

    @Nullable
    @Override
    public String getDefaultName() {
        return defaultName;
    }

    @Override
    public void setDefaultName(@NonNull String defaultName) {
        if (defaultName.equals(getNameOfFrontCamera())) {
            this.defaultName = defaultName;
        } else if (defaultName.equals(getNameOfBackCamera())) {
            this.defaultName = defaultName;
        }
    }

    @Nullable
    @Override
    public String getNameOfFrontCamera() {
        try {
            return enumerator.getNameOfFrontFacingDevice();
        } catch (AssertionError e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    @Override
    public String getNameOfBackCamera() {
        try {
            return enumerator.getNameOfBackFacingDevice();
        } catch (AssertionError e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean isFrontFacing(@Nullable String deviceName) {
        try {
            return enumerator.isFrontFacing(deviceName);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}
