/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.http.HttpCallback;
import com.voxeet.sdk.core.http.HttpHelper;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.success.StopRecordingResultEvent;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class StopRecordingPromiseable
extends AbstractPromiseable<Boolean> {
    public StopRecordingPromiseable(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    ConferenceInformation information = StopRecordingPromiseable.this.getInformation();
                    if (null == information || null == information.getConference().getConferenceId()) {
                        throw new NotInConferenceException();
                    }
                    Call<ResponseBody> user = StopRecordingPromiseable.this.getProvider().getStopRecordingObservable(information.getConference().getConferenceId());
                    HttpHelper.enqueue(user, new HttpCallback<ResponseBody>(){

                        @Override
                        public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                            if (response.code() == 200) {
                                StopRecordingPromiseable.this.log("Conference recording stopped");
                            }
                            try {
                                StopRecordingPromiseable.this.log("onNext: " + ((ResponseBody)response.body()).string());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            StopRecordingPromiseable.this.getEventBus().post((Object)new StopRecordingResultEvent(response.code() == 200));
                            solver.resolve((Object)(response.code() == 200 ? 1 : 0));
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                            HttpException.dumpErrorResponse(response);
                            StopRecordingPromiseable.this.log("Failed to cancel mConference recording");
                            StopRecordingPromiseable.this.getEventBus().post((Object)new StopRecordingResultEvent(StopRecordingPromiseable.this.getParent().handleError(e), false));
                            solver.reject(e);
                        }
                    });
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    solver.reject(e);
                }
            }
        });
    }
}

