/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.camera;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.camera.CameraEnumeratorWrapper;
import org.webrtc.Camera1Enumerator;

public class CameraEnumeratorPreLollipopWrapper
implements CameraEnumeratorWrapper {
    private String frontName;
    private String backName;
    private String defaultCamera;
    private Camera1Enumerator enumerator = new Camera1Enumerator(false);

    public CameraEnumeratorPreLollipopWrapper(@NonNull Context context) {
        String[] names = this.enumerator.getDeviceNames();
        if (null != names && names.length > 0) {
            for (String name : names) {
                if (this.enumerator.isFrontFacing(name)) {
                    this.frontName = this.defaultCamera;
                    this.defaultCamera = name;
                    continue;
                }
                if (!this.enumerator.isBackFacing(name)) continue;
                this.backName = name;
            }
        }
        if (null == this.defaultCamera) {
            this.defaultCamera = this.backName;
        }
    }

    @Override
    @Nullable
    public String getDefaultName() {
        return this.defaultCamera;
    }

    @Override
    public void setDefaultName(@NonNull String defaultName) {
        if (null != defaultName) {
            if (defaultName.equals(this.frontName)) {
                this.defaultCamera = this.frontName;
            }
            if (defaultName.equals(this.backName)) {
                this.defaultCamera = this.backName;
            }
        }
    }

    @Override
    @Nullable
    public String getNameOfFrontCamera() {
        return this.frontName;
    }

    @Override
    @Nullable
    public String getNameOfBackCamera() {
        return this.backName;
    }

    @Override
    public boolean isFrontFacing(@Nullable String deviceName) {
        if (null != deviceName) {
            return deviceName.equals(this.getNameOfFrontCamera());
        }
        return false;
    }
}

