/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.camera;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.camera.CameraEnumeratorWrapper;
import com.voxeet.android.media.video.Camera2Enumerator;

public class CameraEnumeratorLollipopWrapper
implements CameraEnumeratorWrapper {
    private Camera2Enumerator enumerator;
    private String defaultName;

    public CameraEnumeratorLollipopWrapper(Context context) {
        this.enumerator = new Camera2Enumerator(context);
        this.defaultName = this.enumerator.getNameOfFrontFacingDevice();
        if (null == this.defaultName) {
            this.defaultName = this.enumerator.getNameOfBackFacingDevice();
        }
        if (null == this.defaultName) {
            String[] names = this.enumerator.getDeviceNames();
            this.defaultName = null != names && names.length > 0 ? names[0] : null;
        }
    }

    @Override
    @Nullable
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    public void setDefaultName(@NonNull String defaultName) {
        if (defaultName.equals(this.getNameOfFrontCamera())) {
            this.defaultName = defaultName;
        } else if (defaultName.equals(this.getNameOfBackCamera())) {
            this.defaultName = defaultName;
        }
    }

    @Override
    @Nullable
    public String getNameOfFrontCamera() {
        try {
            return this.enumerator.getNameOfFrontFacingDevice();
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    @Nullable
    public String getNameOfBackCamera() {
        try {
            return this.enumerator.getNameOfBackFacingDevice();
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean isFrontFacing(@Nullable String deviceName) {
        try {
            return this.enumerator.isFrontFacing(deviceName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

