package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.VIDEO_PRESENTATION_PLAY)
public class VideoPresentationPlay extends Event {

    private String key;

    private String conferenceId;

    private String userId;

    private long timestamp;

    public VideoPresentationPlay() {

    }

    public VideoPresentationPlay(String key, String conferenceId, String userId, long timestamp) {
        this();
        setKey(key);
        setConferenceId(conferenceId);
        setUserId(userId);
        setTimestamp(timestamp);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getKey() {
        return key;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public String getUserId() {
        return userId;
    }

    public long getTimestamp() {
        return timestamp;
    }

    @Override
    public String getType() {
        return EventNames.VIDEO_PRESENTATION_PLAY;
    }
}
