package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class SendBroadcastCommandEvent {

    private final String COMMAND = "BROADCAST_COMMAND";
    private final String MESSAGE = "BROADCAST_MESSAGE";

    private String messageType;

    private String message;

    public SendBroadcastCommandEvent(String message) {
        this.messageType = COMMAND;
        this.message = message;
    }

    public String getMessageType() {
        return messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
