package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.RECORDING_STATUS_UPDATE)
public class RecordingStatusUpdateEvent extends Event {

    @JsonProperty("conference_id")
    private String conferenceId;

    @JsonProperty("user_id")
    private String userId;

    @JsonProperty("recording_status")
    private String recordingStatus;

    @JsonProperty("start_record_timestamp")
    private long timeStamp;

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getRecordingStatus() {
        return recordingStatus;
    }

    public void setRecordingStatus(String recordingStatus) {
        this.recordingStatus = recordingStatus;
    }

    public long getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public String getType() {
        return EventNames.RECORDING_STATUS_UPDATE;
    }
}
