package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.MEET_ACTIVITY_DELETED)
public class MeetActivityDeletedEvent extends Event {

    private String meetId;

    public String getMeetId() {
        return meetId;
    }

    public void setMeetId(String meetId) {
        this.meetId = meetId;
    }

    @Override
    public String getType() {
        return EventNames.MEET_ACTIVITY_DELETED;
    }
}
