package com.voxeet.sdk.core.services.localstats.events;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.core.services.localstats.LocalStatsUserInfo;
import com.voxeet.sdk.core.services.localstats.LocalStatsUserTypes;

public class LocalStatsUserChangeEvent {

    @NonNull
    private String userId;

    @Nullable
    private LocalStatsUserInfo userInfo;

    @NonNull
    private LocalStatsUserTypes lastKnownType;

    @NonNull
    private LocalStatsUserTypes currentType;

    public LocalStatsUserChangeEvent() {
        userId = "";
        lastKnownType = LocalStatsUserTypes.DEFAULT;
        currentType = LocalStatsUserTypes.DEFAULT;

    }

    public LocalStatsUserChangeEvent(@NonNull String userId,
                                     @NonNull LocalStatsUserInfo userInfo,
                                     @NonNull LocalStatsUserTypes lastKnownType,
                                     @NonNull LocalStatsUserTypes currentType) {
        this();

        this.userId = userId;
        this.userInfo = userInfo;
        this.lastKnownType = lastKnownType;
        this.currentType = currentType;
    }

    @NonNull
    public String getUserId() {
        return userId;
    }

    @Nullable
    public LocalStatsUserInfo getUserInfo() {
        return userInfo;
    }

    @NonNull
    public LocalStatsUserTypes getLastKnownType() {
        return lastKnownType;
    }

    @NonNull
    public LocalStatsUserTypes getCurrentKnownType() {
        return currentType;
    }
}
