package com.voxeet.sdk.core.network;

import com.voxeet.sdk.events.success.GetTokenUploadSuccessEvent;
import com.voxeet.sdk.events.success.GetUserProfileSuccessEvent;
import com.voxeet.sdk.events.success.LoginSuccessResponseEvent;
import com.voxeet.sdk.events.success.OwnProfileSuccessEvent;
import com.voxeet.sdk.json.EmailEvent;
import com.voxeet.sdk.json.LoginEvent;
import com.voxeet.sdk.json.ResendActivationEvent;
import com.voxeet.sdk.json.ResetPasswordEvent;
import com.voxeet.sdk.json.SignUpEvent;
import com.voxeet.sdk.json.SocialLoginEvent;
import com.voxeet.sdk.json.UpdatePasswordEvent;
import com.voxeet.sdk.json.UpdatePresenceEvent;
import com.voxeet.sdk.json.UpdateProfileEvent;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;

public interface IUserRService {

    @POST("users/login")
    Call<LoginSuccessResponseEvent> login(@Body LoginEvent loginEvent);

    @POST("mobile/loginValidated")
    Call<LoginSuccessResponseEvent> socialLogin(@Body SocialLoginEvent loginEvent);

    @POST("users/logout")
    Call<ResponseBody> logout();

    @POST("users/resetPassword")
    Call<ResponseBody> resetPassword(@Body ResetPasswordEvent event);

    @POST("users/create")
    Call<ResponseBody> signup(@Body SignUpEvent event);

    @PUT("users/me")
    Call<ResponseBody> updateProfile(@Body UpdateProfileEvent event);

    @PUT("users/me/updatePresence")
    Call<ResponseBody> updatePresence(@Body UpdatePresenceEvent event);

    @GET("users/me")
    @Headers("Content-Type: application/json")
    Call<OwnProfileSuccessEvent> getOwnProfile();

    @GET("users/me/getUploadToken")
    @Headers("Content-Type: application/json")
    Call<GetTokenUploadSuccessEvent> getUploadToken();

    @GET("users/{userId}")
    Call<GetUserProfileSuccessEvent> getUserProfile(@Path("userId") String userId);

    @POST("users/resendActivation")
    Call<ResponseBody> resendActivation(@Body ResendActivationEvent event);

    @POST("users/resendValidation")
    Call<ResponseBody> resendValidation(@Body ResendActivationEvent event);

    @PUT("users/me/addEmail")
    Call<ResponseBody> addEmail(@Body EmailEvent event);

    @PUT("users/me/removeEmail")
    Call<ResponseBody> removeEmail(@Body EmailEvent event);

    @PUT("users/me/setDefaultEmail")
    Call<ResponseBody> setDefaultEmail(@Body EmailEvent event);

    @PUT("/users/me/updatePassword")
    Call<ResponseBody> updatePassword(@Body UpdatePasswordEvent event);
}