package com.voxeet.sdk.core.impl;

import com.voxeet.android.media.peer.SdpDescription;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.network.ISdkConferenceRService;
import com.voxeet.sdk.events.success.GetConferenceStatusEvent;
import com.voxeet.sdk.events.success.ReplayConferenceEvent;
import com.voxeet.sdk.events.success.ResumeConference;
import com.voxeet.sdk.json.BroadcastEvent;
import com.voxeet.sdk.json.CreateConferenceParams;
import com.voxeet.sdk.json.JoinParameters;
import com.voxeet.sdk.json.SdkConferenceInvitation;
import com.voxeet.sdk.json.SdkConferenceReplayBody;
import com.voxeet.sdk.json.StartScreenSharingResponse;
import com.voxeet.sdk.json.StartVideoResponse;
import com.voxeet.sdk.json.StopScreenSharingResponse;
import com.voxeet.sdk.json.StopVideoResponse;
import com.voxeet.sdk.models.CandidatesPush;
import com.voxeet.sdk.models.ConferenceResponse;
import com.voxeet.sdk.models.HistoryConference;
import com.voxeet.sdk.models.SubscribeConference;

import java.util.List;

import okhttp3.ResponseBody;
import retrofit2.Call;

public class ConferenceSdkObservableProvider extends AbstractConferenceSdkObservableProvider<ISdkConferenceRService> {

    private ISdkConferenceRService mService;

    @Override
    protected ISdkConferenceRService getService() {
        return mService;
    }

    public Class getRetrofitInjectedClass() {
        return ISdkConferenceRService.class;
    }

    public void setRetrofitInstantiatedProvider(ISdkConferenceRService service) {
        mService = service;
    }

    @Override
    public Call<ResponseBody> leaveConference(String conferenceId) {
        return getService().leaveConference(conferenceId);
    }

    @Override
    public Call<ResponseBody> getDeclineObservable(String conferenceId) {
        return getService().decline(conferenceId);
    }

    @Override
    public Call<StartVideoResponse> getStartVideoObservable(String conferenceId, String id) {
        return getService().startVideo(conferenceId, id);
    }

    @Override
    public Call<StopVideoResponse> getStopVideoObservable(String conferenceId, String id) {
        return getService().stopVideo(conferenceId, id);
    }

    @Override
    public Call<StartScreenSharingResponse> getStartScreenShareObservable(String conferenceId, String id) {
        return getService().startScreenShare(conferenceId);
    }

    @Override
    public Call<StopScreenSharingResponse> getStopScreenShareObservable(String conferenceId, String id) {
        return getService().stopScreenShare(conferenceId);
    }

    @Override
    public Call<ConferenceResponse> getCreateConferenceObservable(CreateConferenceParams params) {
        return getService().createConference(params); //with default stats to true
    }

    @Override
    public Call<ConferenceResponse> getCreateDemoObservable() {
        return getService().createDemo();
    }

    @Override
    public Call<ResponseBody> getInviteObservable(String conferenceId, SdkConferenceInvitation sdkConferenceInvitation) {
        return getService().invite(conferenceId, sdkConferenceInvitation);
    }

    @Override
    public Call<ReplayConferenceEvent> getReplayObservable(String conferenceId, SdkConferenceReplayBody sdkConferenceReplayBody) {
        return getService().replay(conferenceId, sdkConferenceReplayBody);
    }

    @Override
    public Call<ResponseBody> getStartRecordingObservable(String conferenceId) {
        return getService().startRecording(conferenceId);
    }

    @Override
    public Call<ResponseBody> getStopRecordingObservable(String conferenceId) {
        return getService().stopRecording(conferenceId);
    }

    @Override
    public Call<ResponseBody> getLogOutObservable(String token) {
        return getService().logout(token);
    }

    @Override
    public Call<GetConferenceStatusEvent> getConferenceStatusObservable(String conferenceId) {
        return getService().conferenceStatus(conferenceId);
    }

    @Override
    public Call<List<HistoryConference>> getConferenceHistoryObservable(String conferenceId) {
        return getService().conferenceHistory(conferenceId);
    }

    @Override
    public Call<SubscribeConference> getSubscribeObservable(String conferenceId) {
        return getService().subscribe(conferenceId);
    }

    @Override
    public Call<ResponseBody> getUnSubscribeObservable(String conferenceId) {
        return getService().unSubscribe(conferenceId);
    }

    @Override
    public Call<ResponseBody> getSubscribeForCallObservable(String conferenceId) {
        return getService().subscribeForCall(conferenceId);
    }

    @Override
    public Call<ResponseBody> getUnSubscribeFromCallObservable(String conferenceId) {
        return getService().unsubscribeFromCall(conferenceId);
    }

    @Override
    public Call<ResumeConference> joinConference(String conferenceId, JoinParameters deviceEvent) {
        return getService().joinConference(conferenceId, deviceEvent);
    }

    @Override
    public Call<ResponseBody> answerConference(String conferenceId, String peer, SdpDescription description) {
        return getService().answerConference(conferenceId, peer, description);
    }

    @Override
    public Call<ResponseBody> broadcastMessage(String conferenceId, BroadcastEvent broadcastEvent) {
        return getService().broadcastMessage(conferenceId, broadcastEvent);
    }

    @Override
    public Call<ResponseBody> candidates(String conferenceId, String peerId, CandidatesPush candidates) {
        return getService().candidates(conferenceId, peerId, candidates);
    }

    @Override
    public Call<ResponseBody> renegociate(String conferenceId) {
        return getService().renegociate(conferenceId);
    }

    @Override
    public Call<ResponseBody> iceRestart(String conferenceId) {
        return getService().iceRestart(conferenceId);
    }
}
