package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.ConferenceService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.http.HttpCallback;
import com.voxeet.sdk.core.http.HttpHelper;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.PromiseDeclineConferenceResultEventException;
import com.voxeet.sdk.events.success.DeclineConferenceResultEvent;

import org.greenrobot.eventbus.EventBus;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class DeclinePromise extends AbstractPromiseable<DeclineConferenceResultEvent> {
    private static final String TAG = DeclinePromise.class.getSimpleName();
    private final String conferenceId;

    public DeclinePromise(@NonNull ConferenceService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus,
                          @NonNull String conferenceId) {
        super(parent, mediaService, provider, information, eventBus);
        this.conferenceId = conferenceId;
    }

    @NonNull
    @Override
    public Promise<DeclineConferenceResultEvent> createPromise() {
        return new Promise<>(new PromiseSolver<DeclineConferenceResultEvent>() {
            @Override
            public void onCall(@NonNull final Solver<DeclineConferenceResultEvent> solver) {
                final Call<ResponseBody> user = getProvider().getDeclineObservable(conferenceId);
                HttpHelper.enqueue(user, new HttpCallback<ResponseBody>() {
                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        Log.d(TAG, "IConference declined with id: " + conferenceId);

                        DeclineConferenceResultEvent event = new DeclineConferenceResultEvent(response.code() == 200);
                        getEventBus().post(event);
                        solver.resolve(event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable t, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);

                        t.printStackTrace();

                        DeclineConferenceResultEvent event = new DeclineConferenceResultEvent(getParent().handleError(t), false);
                        getEventBus().post(event);
                        solver.reject(new PromiseDeclineConferenceResultEventException(event));
                    }
                });
            }
        });
    }
}
