package com.voxeet.android.media.peer;

public class SdpDescription {

    public String type;

    public String sdp;

    public long ssrc;

    public SdpDescription(String type, String sdp) {
        //prevent the need for the static and JsonIgnore
        final String SSRC_TAG_KEY = "a=ssrc:";

        this.type = type;
        this.sdp = sdp;
        this.ssrc = 0;

        for (String line : sdp.split("\\r?\\n")) {
            if (line.contains(SSRC_TAG_KEY)) {
                this.ssrc = Long.parseLong(line.substring(SSRC_TAG_KEY.length()).split("\\s")[0]);
                break;
            }
        }
    }
}
