package com.voxeet.android.media.peer;

import com.voxeet.android.media.SdpCandidate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SdpCandidates {
    private Map<String, List<SdpCandidate>> mCandidates;

    public SdpCandidates() {
        mCandidates = new HashMap<String, List<SdpCandidate>>();
    }

    public void add(String peer, SdpCandidate candidate) {
        if (mCandidates.containsKey(peer)) {
            mCandidates.get(peer).add(candidate);
        } else {
            List<SdpCandidate> candList = new ArrayList<>();
            candList.add(candidate);
            mCandidates.put(peer, candList);
        }
    }

    public List<SdpCandidate> candidates(String peer) {
        if (!mCandidates.containsKey(peer)) {
            List<SdpCandidate> candList = new ArrayList<>();
            mCandidates.put(peer, candList);
        }

        return this.mCandidates.get(peer);
    }
}
