/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.models.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import voxeet.com.sdk.models.Email;
import voxeet.com.sdk.models.abs.UserProfile;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DefaultOwnProfile
implements UserProfile {
    private String firstName;
    private String lastName;
    private String nickName;
    private String callLocalPart;
    private boolean editable;
    private String profileType;
    private String userId;
    private String email;
    private String photoId;
    private String statusPhrase;
    private String country;
    private String city;
    private String company;
    private String jobTitle;
    private String presenceStatus;
    private boolean isPro;
    private List<Email> emails = new ArrayList<Email>();
    private List<String> tags = new ArrayList<String>();

    public DefaultOwnProfile() {
    }

    public DefaultOwnProfile(UserProfile user) {
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.nickName = user.getNickName();
        this.callLocalPart = user.getCallLocalPart();
        this.editable = user.isEditable();
        this.profileType = user.getProfileType();
        this.userId = user.getUserId();
        this.email = user.getEmail();
        this.photoId = user.getPhotoId();
        this.statusPhrase = user.getStatusPhrase();
        this.company = user.getCompany();
        this.country = user.getCountry();
        this.jobTitle = user.getJobTitle();
        this.presenceStatus = user.getPresenceStatus();
        this.isPro = user.isPro();
        if (user.getEmails() != null) {
            this.emails.addAll(user.getEmails());
        }
        if (user.getTags() != null) {
            this.tags.addAll(user.getTags());
        }
    }

    @Override
    public boolean isPro() {
        return this.isPro;
    }

    public void setPro(boolean pro) {
        this.isPro = pro;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    @Override
    public String getCallLocalPart() {
        return this.callLocalPart;
    }

    public void setCallLocalPart(String callLocalPart) {
        this.callLocalPart = callLocalPart;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public List<Email> getEmails() {
        return this.emails;
    }

    public void setEmails(List<Email> emails) {
        if (emails != null && (this.emails == null || this.emails.size() < emails.size())) {
            this.emails = emails;
        }
    }

    @Override
    public List<String> getTags() {
        if (this.tags == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.tags);
        return list;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public String getProfileType() {
        return this.profileType;
    }

    public void setProfileType(String profileType) {
        this.profileType = profileType;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getPhotoId() {
        return this.photoId;
    }

    public void setPhotoId(String photoId) {
        this.photoId = photoId;
    }

    @Override
    public String getStatusPhrase() {
        return this.statusPhrase;
    }

    public void setStatusPhrase(String statusPhrase) {
        this.statusPhrase = statusPhrase;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Override
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Override
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    @Override
    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    @Override
    public String getPresenceStatus() {
        return this.presenceStatus;
    }

    @Override
    public boolean isObjectValid() {
        return true;
    }

    public void setPresenceStatus(String presenceStatus) {
        if (presenceStatus != null) {
            this.presenceStatus = presenceStatus;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultOwnProfile profile = (DefaultOwnProfile)obj;
        return profile.getUserId().equals(this.userId);
    }
}

