package voxeet.com.sdk.models.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import voxeet.com.sdk.models.abs.ScheduleMeeting;
import voxeet.com.sdk.models.abs.UserProfile;

/**
 * Created by RomainB on 5/25/16.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class DefaultScheduleMeeting implements ScheduleMeeting {

    @JsonProperty("nextOccurrenceTimestamp")
    private long nextOccurence;

    private List<DefaultUserProfile> participants;

    @JsonProperty("ownerProfile")
    private DefaultUserProfile owner;

    private String conferenceType;

    private String description;

    private String title;

    private String meetingId;

    private String meetId;

    private String liveConferenceId;

    @JsonProperty("startAt")
    private long startAt;

    @JsonProperty("endAt")
    private long end;

    @JsonProperty("humanReadableRecurrenceRule")
    private String recurrence;

    private String pstnPinCode;

    public String getMeetId() {
        return meetId;
    }

    public void setMeetId(String meetId) {
        this.meetId = meetId;
    }

    public String getLiveConferenceId() {
        return liveConferenceId;
    }

    public void setLiveConferenceId(String liveConferenceId) {
        this.liveConferenceId = liveConferenceId;
    }

    public String getPstnPinCode() {
        return pstnPinCode;
    }

    public void setPstnPinCode(String pstnPinCode) {
        this.pstnPinCode = pstnPinCode;
    }

    public long getNextOccurence() {
        return nextOccurence;
    }

    public void setNextOccurence(long nextOccurence) {
        this.nextOccurence = nextOccurence;
    }

    public List<UserProfile> getParticipants() {
        List<? extends UserProfile> profiles = participants;
        return (List<UserProfile>) profiles;
    }

    public void setParticipants(List<DefaultUserProfile> participants) {
        this.participants = participants;
    }

    public UserProfile getOwner() {
        return owner;
    }

    public void setOwner(DefaultUserProfile owner) {
        this.owner = owner;
    }

    public String getConferenceType() {
        return conferenceType;
    }

    public void setConferenceType(String conferenceType) {
        this.conferenceType = conferenceType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMeetingId() {
        return meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public long getStartAt() {
        return startAt;
    }

    public void setStartAt(long startAt) {
        this.startAt = startAt;
    }

    public long getEnd() {
        return end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public String getRecurrence() {
        return recurrence;
    }

    public void setRecurrence(String recurrence) {
        this.recurrence = recurrence;
    }
}
