package voxeet.com.sdk.models.impl;

import android.support.annotation.NonNull;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.ConferenceQuality;
import voxeet.com.sdk.models.ConferenceUserStatus;
import voxeet.com.sdk.models.abs.ConferenceUser;

/**
 * Created by RomainB on 4/21/16.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class DefaultConferenceUser implements ConferenceUser {

    private String TAG = DefaultConferenceUser.class.getSimpleName();

    @JsonIgnore
    private boolean isMuted = false;

    @JsonIgnore
    private UserInfo userInfo;

    @JsonProperty("user_id")
    private String userId;

    private String quality;

    @JsonIgnore
    private String deviceType;

    @JsonIgnore
    private String status;

    @JsonIgnore
    private ConferenceUserStatus conferenceStatus;

    private String conferenceStatusToString;

    private boolean isOwner;

    @JsonIgnore
    private DefaultUserProfile profile;

    private boolean isRecordingOwner = false;

    private boolean isWhispering = false;

    public DefaultConferenceUser() {
        this.userInfo = null;
    }

    public DefaultConferenceUser(String userId, String device) {
        this.userId = userId;

        this.deviceType = device;

        this.conferenceStatus = ConferenceUserStatus.ON_AIR;

        this.userInfo = null;

        this.isMuted = false;

        this.setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
    }

    public DefaultConferenceUser(String userId, String device, UserInfo userInfo) {
        this.userId = userId;

        this.deviceType = device;

        this.profile = new DefaultUserProfile();
        this.profile.setUserId(userId);
        this.profile.setPhotoId(userInfo.getAvatarUrl());
        this.profile.setFirstName(userInfo.getName());
        this.profile.setLastName(userInfo.getName());
        this.profile.setNickName(userInfo.getName());

        this.setWhispering(false);

        this.setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());

        this.userInfo = userInfo;

        this.isMuted = false;
    }

    public DefaultConferenceUser(DefaultUserProfile profile) {
        this.profile = profile;

        this.userId = profile.getUserId();

        this.setConferenceStatus(ConferenceUserStatus.IN_PROGRESS);

        this.setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
    }

    @Override
    public boolean isRecordingOwner() {
        return isRecordingOwner;
    }

    @Override
    public boolean isWhispering() {
        return isWhispering;
    }

    //TODO reminiscence from RealmObject isValid() - remove ?
    @Override
    public boolean isUserValid() {
        return true;
    }

    public void setOwner(boolean owner) {
        isOwner = owner;
    }

    public void setRecordingOwner(boolean recordingOwner) {
        isRecordingOwner = recordingOwner;
    }

    public void setWhispering(boolean whispering) {
        isWhispering = whispering;
    }

    public void setIsRecordingOwner(boolean isRecordingOwner) {
        this.isRecordingOwner = isRecordingOwner;
    }

    @Override
    public ConferenceUserStatus getConferenceStatus() {
        if (conferenceStatus == null && conferenceStatusToString != null)
            return ConferenceUserStatus.valueOf(conferenceStatusToString);
        return conferenceStatus;
    }

    public DefaultConferenceUser setConferenceStatus(@NonNull ConferenceUserStatus conferenceStatus) {
        this.conferenceStatus = conferenceStatus;

        this.conferenceStatusToString = conferenceStatus.toString();
        return this;
    }

    @Override
    public DefaultUserProfile getProfile() {
        return profile;
    }

    public void setProfile(DefaultUserProfile profile) {
        this.profile = profile;
    }

    @Deprecated
    @Override
    public String getStatus() {
        //return status
        return getConferenceStatusToString();
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    @Override
    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    @Override
    public String getQuality() {
        return quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    @Override
    public UserInfo getUserInfo() {
        return userInfo;
    }

    @Override
    public boolean isMuted() {
        return isMuted;
    }

    public void setMuted(boolean muted) {
        isMuted = muted;
    }

    public String getConferenceStatusToString() {
        return conferenceStatusToString;
    }

    public void setConferenceStatusToString(String conferenceStatusToString) {
        this.conferenceStatusToString = conferenceStatusToString;
    }

    public boolean isOwner() {
        return isOwner;
    }

    public DefaultConferenceUser setIsOwner(boolean isOwner) {
        this.isOwner = isOwner;
        return this;
    }

    @Override
    public String toString() {
        return "DefaultConferenceUser{" +
                "userInfo=" + userInfo +
                ", userId='" + userId + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) return false;

        if (obj instanceof DefaultConferenceUser) {
            DefaultConferenceUser user = (DefaultConferenceUser) obj;
            return null != user.getUserId() && user.getUserId().equals(getUserId());
        }
        return super.equals(obj);
    }

    public void updateIfNeeded(String name, String avatarUrl) {
        if(null == userInfo) {
            userInfo = new UserInfo();
        }

        userInfo.setName(name);
        userInfo.setAvatarUrl(avatarUrl);
    }
}
