/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.voxeet.sdk.events.BaseEvent;
import com.voxeet.sdk.events.error.SocketErrorEvent;
import com.voxeet.sdk.events.success.BadgeUpdate;
import com.voxeet.sdk.events.success.ConferenceDestroyedPushEvent;
import com.voxeet.sdk.events.success.ConferenceEndedEvent;
import com.voxeet.sdk.events.success.ConferenceStatsEvent;
import com.voxeet.sdk.events.success.ConferenceUpdated;
import com.voxeet.sdk.events.success.ConferenceUpdatedEvent;
import com.voxeet.sdk.events.success.ConferenceUserAddedEvent;
import com.voxeet.sdk.events.success.ConferenceUserSwitchEvent;
import com.voxeet.sdk.events.success.ContactAddedEvent;
import com.voxeet.sdk.events.success.FileConvertedEvent;
import com.voxeet.sdk.events.success.FilePresentationChangeEvent;
import com.voxeet.sdk.events.success.FilePresentationStartEvent;
import com.voxeet.sdk.events.success.FilePresentationStartedEvent;
import com.voxeet.sdk.events.success.FilePresentationStopEvent;
import com.voxeet.sdk.events.success.FilePresentationStoppedEvent;
import com.voxeet.sdk.events.success.FilePresentationUpdatedEvent;
import com.voxeet.sdk.events.success.InvitationReceived;
import com.voxeet.sdk.events.success.MeetingActivityAdded;
import com.voxeet.sdk.events.success.MeetingActivityDeleted;
import com.voxeet.sdk.events.success.MeetingActivityUpdated;
import com.voxeet.sdk.events.success.MeetingAddedOrUpdated;
import com.voxeet.sdk.events.success.MeetingDeleted;
import com.voxeet.sdk.events.success.MeetingEventAddedOrUpdated;
import com.voxeet.sdk.events.success.MeetingReadTimeStampUpdated;
import com.voxeet.sdk.events.success.MessageReceived;
import com.voxeet.sdk.events.success.OfferCreatedEvent;
import com.voxeet.sdk.events.success.OwnConferenceStartedEvent;
import com.voxeet.sdk.events.success.OwnConferenceUserSwitchEvent;
import com.voxeet.sdk.events.success.OwnContactRemoved;
import com.voxeet.sdk.events.success.OwnExternalInvitationSent;
import com.voxeet.sdk.events.success.OwnProfileUpdatedEvent;
import com.voxeet.sdk.events.success.OwnUserInvitedEvent;
import com.voxeet.sdk.events.success.ParticipantUpdatedEvent;
import com.voxeet.sdk.events.success.PeerConnectionStatusUpdatedEvent;
import com.voxeet.sdk.events.success.PlayEmoSphereEvent;
import com.voxeet.sdk.events.success.ProfileUpdated;
import com.voxeet.sdk.events.success.QualityUpdatedEvent;
import com.voxeet.sdk.events.success.RecordingStatusUpdate;
import com.voxeet.sdk.events.success.RenegociationEndedEvent;
import com.voxeet.sdk.events.success.RenegociationUpdate;
import com.voxeet.sdk.events.success.SocketConnectEvent;
import com.voxeet.sdk.events.success.SocketDisconnectEvent;
import com.voxeet.sdk.events.success.SocketStateChangeEvent;
import com.voxeet.sdk.events.success.TypingDetectionEvent;
import com.voxeet.sdk.events.success.UserInvitedEvent;
import com.voxeet.sdk.events.success.VideoPresentationPausedEvent;
import com.voxeet.sdk.events.success.VideoPresentationPlayEvent;
import com.voxeet.sdk.events.success.VideoPresentationSeekEvent;
import com.voxeet.sdk.events.success.VideoPresentationStartedEvent;
import com.voxeet.sdk.events.success.VideoPresentationStoppedEvent;
import com.voxeet.sdk.events.success.WhisperInviteAcceptedEvent;
import com.voxeet.sdk.events.success.WhisperInviteDeclinedEvent;
import com.voxeet.sdk.events.success.WhisperInviteReceivedEvent;
import com.voxeet.sdk.events.success.WhisperLeftEvent;
import com.voxeet.sdk.factories.EventsFactory;
import com.voxeet.sdk.json.BadgeUpdatedEvent;
import com.voxeet.sdk.json.BroadcastEvent;
import com.voxeet.sdk.json.ConferenceDestroyedPush;
import com.voxeet.sdk.json.ConferenceEnded;
import com.voxeet.sdk.json.ConferenceMessageReceived;
import com.voxeet.sdk.json.ConferenceStats;
import com.voxeet.sdk.json.ConferenceUserAdded;
import com.voxeet.sdk.json.ConferenceUserSwitch;
import com.voxeet.sdk.json.ContactAdded;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.FileAdded;
import com.voxeet.sdk.json.FileAddedEvent;
import com.voxeet.sdk.json.FileConverted;
import com.voxeet.sdk.json.FileDeleted;
import com.voxeet.sdk.json.FileDeletedEvent;
import com.voxeet.sdk.json.FilePresentationChange;
import com.voxeet.sdk.json.FilePresentationStart;
import com.voxeet.sdk.json.FilePresentationStarted;
import com.voxeet.sdk.json.FilePresentationStop;
import com.voxeet.sdk.json.FilePresentationStopped;
import com.voxeet.sdk.json.FilePresentationUpdated;
import com.voxeet.sdk.json.InvitationReceivedEvent;
import com.voxeet.sdk.json.MeetActivityAddedEvent;
import com.voxeet.sdk.json.MeetActivityDeletedEvent;
import com.voxeet.sdk.json.MeetActivityUpdatedEvent;
import com.voxeet.sdk.json.MeetingAddedOrUpdatedEvent;
import com.voxeet.sdk.json.MeetingDeletedEvent;
import com.voxeet.sdk.json.MeetingEventAddedOrUpdatedEvent;
import com.voxeet.sdk.json.MeetingReadTimeStampUpdatedEvent;
import com.voxeet.sdk.json.OfferCreated;
import com.voxeet.sdk.json.OwnConferenceCreated;
import com.voxeet.sdk.json.OwnConferenceUserSwitch;
import com.voxeet.sdk.json.OwnContactRemovedEvent;
import com.voxeet.sdk.json.OwnExternalInvitationSentEvent;
import com.voxeet.sdk.json.OwnProfileUpdated;
import com.voxeet.sdk.json.OwnUserInvited;
import com.voxeet.sdk.json.ParticipantUpdated;
import com.voxeet.sdk.json.PeerConnectionStatusUpdated;
import com.voxeet.sdk.json.PlayEmoSphere;
import com.voxeet.sdk.json.ProfileUpdatedEvent;
import com.voxeet.sdk.json.QualityUpdated;
import com.voxeet.sdk.json.RecordingStatusUpdateEvent;
import com.voxeet.sdk.json.TypingDetection;
import com.voxeet.sdk.json.UserInvited;
import com.voxeet.sdk.json.VideoPresentationPaused;
import com.voxeet.sdk.json.VideoPresentationPlay;
import com.voxeet.sdk.json.VideoPresentationSeek;
import com.voxeet.sdk.json.VideoPresentationStarted;
import com.voxeet.sdk.json.VideoPresentationStopped;
import com.voxeet.sdk.json.WhisperInvitationAccepted;
import com.voxeet.sdk.json.WhisperInvitationDeclined;
import com.voxeet.sdk.json.WhisperInvitationReceived;
import com.voxeet.sdk.json.WhisperLeft;
import org.greenrobot.eventbus.EventBus;

public class VoxeetDispatcher {
    private static final String TAG = VoxeetDispatcher.class.getSimpleName();
    private static EventBus eventBus = EventBus.getDefault();
    private final Gson sGson = new GsonBuilder().serializeNulls().create();

    public static void dispatch(String eventName, String message) {
        Log.d((String)TAG, (String)("dispatch: " + eventName + " := " + message));
        try {
            BaseEvent event;
            switch (eventName) {
                case "SOCKET_DISCONNECTED": {
                    event = VoxeetDispatcher.handleDisconnect(message);
                    break;
                }
                case "SOCKET_ERROR": {
                    event = VoxeetDispatcher.handleError(message);
                    break;
                }
                case "SOCKET_TEXT": {
                    event = VoxeetDispatcher.handleMessage(message);
                    break;
                }
                case "SOCKET_CONNECTED": {
                    event = VoxeetDispatcher.handleSocketConnect(message);
                    break;
                }
                case "SOCKET_STATE_CHANGE": {
                    event = VoxeetDispatcher.handleStateChange(message);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown event type");
                }
            }
            eventBus.post((Object)event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static BaseEvent handleError(String message) {
        return new SocketErrorEvent(message);
    }

    private static BaseEvent handleDisconnect(String message) {
        return new SocketDisconnectEvent(message);
    }

    private static BaseEvent handleStateChange(String message) {
        return new SocketStateChangeEvent(message);
    }

    private static BaseEvent handleSocketConnect(String message) {
        return new SocketConnectEvent(message);
    }

    private static BaseEvent handleMessage(String message) {
        BaseEvent busEvent;
        Event event = EventsFactory.decode(message);
        switch (event.getType()) {
            case "OfferCreated": {
                busEvent = new OfferCreatedEvent(message, (OfferCreated)event);
                break;
            }
            case "ConferenceMessageReceived": {
                busEvent = VoxeetDispatcher.handleConferenceMessage((ConferenceMessageReceived)event);
                break;
            }
            case "ConferenceDestroyedPush": {
                busEvent = new ConferenceDestroyedPushEvent(message, (ConferenceDestroyedPush)event);
                break;
            }
            case "ProfileUpdatedEvent": {
                busEvent = new ProfileUpdated(message, (ProfileUpdatedEvent)event);
                break;
            }
            case "ParticipantUpdated": {
                ParticipantUpdated participantUpdated = (ParticipantUpdated)event;
                busEvent = new ParticipantUpdatedEvent(message, participantUpdated);
                break;
            }
            case "OwnConferenceCreatedEvent": {
                busEvent = new OwnConferenceStartedEvent(message, (OwnConferenceCreated)event);
                break;
            }
            case "OwnProfileUpdatedEvent": {
                busEvent = new OwnProfileUpdatedEvent(message, (OwnProfileUpdated)event);
                break;
            }
            case "OwnExternalInvitationsSentEvent": {
                busEvent = new OwnExternalInvitationSent(message, (OwnExternalInvitationSentEvent)event);
                break;
            }
            case "OwnContactRemovedEvent": {
                busEvent = new OwnContactRemoved(message, (OwnContactRemovedEvent)event);
                break;
            }
            case "MeetingAddedOrUpdatedEvent": {
                busEvent = new MeetingAddedOrUpdated(message, (MeetingAddedOrUpdatedEvent)event);
                break;
            }
            case "MeetingDeletedEvent": {
                busEvent = new MeetingDeleted(message, (MeetingDeletedEvent)event);
                break;
            }
            case "BadgeCounterUpdatedEvent": {
                busEvent = new BadgeUpdate(message, (BadgeUpdatedEvent)event);
                break;
            }
            case "RenegociationEnded": {
                busEvent = new RenegociationUpdate(message, (RenegociationEndedEvent)event);
                break;
            }
            case "BroadcastEvent": {
                busEvent = VoxeetDispatcher.handleBroadcast((BroadcastEvent)event);
                break;
            }
            case "RecordingStatusUpdated": {
                busEvent = new RecordingStatusUpdate(message, (RecordingStatusUpdateEvent)event);
                break;
            }
            case "MeetActivityDeletedEvent": {
                busEvent = new MeetingActivityDeleted(message, (MeetActivityDeletedEvent)event);
                break;
            }
            case "MeetActivityUpdatedEvent": {
                busEvent = new MeetingActivityUpdated(message, (MeetActivityUpdatedEvent)event);
                break;
            }
            case "MeetActivityAddedEvent": {
                busEvent = new MeetingActivityAdded(message, (MeetActivityAddedEvent)event);
                break;
            }
            case "MeetingReadTimestampUpdatedEvent": {
                busEvent = new MeetingReadTimeStampUpdated(message, (MeetingReadTimeStampUpdatedEvent)event);
                break;
            }
            case "InvitationReceivedEvent": {
                busEvent = new InvitationReceived(message, (InvitationReceivedEvent)event);
                break;
            }
            case "MeetingEventAddedOrUpdatedEvent": {
                busEvent = new MeetingEventAddedOrUpdated(message, (MeetingEventAddedOrUpdatedEvent)event);
                break;
            }
            case "FileDeletedEvent": {
                busEvent = new FileDeleted(message, (FileDeletedEvent)event);
                break;
            }
            case "FileSharedEvent": {
                busEvent = new FileAdded(message, (FileAddedEvent)event);
                break;
            }
            case "QualityUpdated": {
                busEvent = new QualityUpdatedEvent(message, (QualityUpdated)event);
                break;
            }
            case "WhisperInvitationReceivedEvent": {
                busEvent = new WhisperInviteReceivedEvent(message, (WhisperInvitationReceived)event);
                break;
            }
            case "WhisperAcceptedEvent": {
                busEvent = new WhisperInviteAcceptedEvent(message, (WhisperInvitationAccepted)event);
                break;
            }
            case "WhisperDeclinedEvent": {
                busEvent = new WhisperInviteDeclinedEvent(message, (WhisperInvitationDeclined)event);
                break;
            }
            case "WhisperLeftEvent": {
                busEvent = new WhisperLeftEvent(message, (WhisperLeft)event);
                break;
            }
            case "OwnUserInvitedEvent": {
                busEvent = new OwnUserInvitedEvent(message, (OwnUserInvited)event);
                break;
            }
            case "UserInvited": {
                busEvent = new UserInvitedEvent(message, (UserInvited)event);
                break;
            }
            case "ParticipantSwitched": {
                busEvent = new ConferenceUserSwitchEvent(message, (ConferenceUserSwitch)event);
                break;
            }
            case "ParticipantAdded": {
                busEvent = new ConferenceUserAddedEvent(message, (ConferenceUserAdded)event);
                break;
            }
            case "OwnParticipantSwitched": {
                busEvent = new OwnConferenceUserSwitchEvent(message, (OwnConferenceUserSwitch)event);
                break;
            }
            case "ConferenceEndedEvent": {
                busEvent = new ConferenceEndedEvent(message, (ConferenceEnded)event);
                break;
            }
            case "ConferenceStatusUpdated": {
                busEvent = new ConferenceUpdatedEvent(message, (ConferenceUpdated)event);
                break;
            }
            case "FileConvertedEvent": {
                busEvent = new FileConvertedEvent(message, (FileConverted)event);
                break;
            }
            case "FilePresentationStarted": {
                busEvent = new FilePresentationStartedEvent(message, (FilePresentationStarted)event);
                break;
            }
            case "FilePresentationStopped": {
                busEvent = new FilePresentationStoppedEvent(message, (FilePresentationStopped)event);
                break;
            }
            case "FilePresentationUpdated": {
                busEvent = new FilePresentationUpdatedEvent(message, (FilePresentationUpdated)event);
                break;
            }
            case "VideoPresentationStarted": {
                busEvent = new VideoPresentationStartedEvent(message, (VideoPresentationStarted)event);
                break;
            }
            case "VideoPresentationStopped": {
                busEvent = new VideoPresentationStoppedEvent(message, (VideoPresentationStopped)event);
                break;
            }
            case "VideoPresentationPlay": {
                busEvent = new VideoPresentationPlayEvent(message, (VideoPresentationPlay)event);
                break;
            }
            case "VideoPresentationPause": {
                busEvent = new VideoPresentationPausedEvent(message, (VideoPresentationPaused)event);
                break;
            }
            case "VideoPresentationSeek": {
                busEvent = new VideoPresentationSeekEvent(message, (VideoPresentationSeek)event);
                break;
            }
            case "ContactsAddedEvent": {
                busEvent = new ContactAddedEvent(message, (ContactAdded)event);
                break;
            }
            case "PeerConnectionStatusUpdatedEvent": {
                busEvent = new PeerConnectionStatusUpdatedEvent(message, (PeerConnectionStatusUpdated)event);
                break;
            }
            case "ConferenceStats": {
                ConferenceStats stats = (ConferenceStats)new Gson().fromJson(message, ConferenceStats.class);
                busEvent = new ConferenceStatsEvent(message, stats);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type of event");
            }
        }
        return busEvent;
    }

    private static BaseEvent handleConferenceMessage(ConferenceMessageReceived event) {
        Event event1 = EventsFactory.decode(event.getMessage());
        if (event1 == null) {
            return new MessageReceived(event.getUserId(), event.getConferenceId(), event.getMessage());
        }
        switch (event1.getType()) {
            case "FilePresentationChange": {
                return new FilePresentationChangeEvent(event.getMessage(), event.getUserId(), event.getConferenceId(), (FilePresentationChange)event1);
            }
            case "FilePresentationStart": {
                return new FilePresentationStartEvent(event.getMessage(), event.getUserId(), event.getConferenceId(), (FilePresentationStart)event1);
            }
            case "FilePresentationStop": {
                return new FilePresentationStopEvent(event.getMessage(), event.getUserId(), event.getConferenceId(), (FilePresentationStop)event1);
            }
            case "VideoPresentationStarted": {
                return new VideoPresentationStartedEvent(event.getMessage(), (VideoPresentationStarted)event1);
            }
            case "VideoPresentationStopped": {
                return new VideoPresentationStoppedEvent(event.getMessage(), (VideoPresentationStopped)event1);
            }
            case "VideoPresentationPlay": {
                return new VideoPresentationPlayEvent(event.getMessage(), (VideoPresentationPlay)event1);
            }
            case "VideoPresentationPause": {
                return new VideoPresentationPausedEvent(event.getMessage(), (VideoPresentationPaused)event1);
            }
            case "VideoPresentationSeek": {
                return new VideoPresentationSeekEvent(event.getMessage(), (VideoPresentationSeek)event1);
            }
            case "PlayEmosphere": {
                return new PlayEmoSphereEvent(event.getMessage(), event.getUserId(), event.getConferenceId(), (PlayEmoSphere)event1);
            }
        }
        return new MessageReceived(event.getUserId(), event.getConferenceId(), event.getMessage());
    }

    private static BaseEvent handleBroadcast(BroadcastEvent event) {
        Event event1 = EventsFactory.decode(event.getMessage());
        switch (event1.getType()) {
            case "TypingDetection": {
                return new TypingDetectionEvent(event.getMessage(), (TypingDetection)event1, event.getUserId(), event.getMeetingId());
            }
        }
        throw new IllegalStateException("Unknown broadcast type event");
    }
}

