package com.voxeet.sdk.models.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Date;

import com.voxeet.sdk.models.MeetingAttributes;
import com.voxeet.sdk.models.abs.MeetingEvent;

/**
 * Created by RomainB on 6/15/16.
 */

@JsonIgnoreProperties(ignoreUnknown = true)
public class DefaultMeetingEvent implements MeetingEvent, Comparable<DefaultMeetingEvent> {

    private static final String TAG = DefaultMeetingEvent.class.getSimpleName();

    @JsonProperty("evtUser")
    private DefaultUserProfile owner;

    private String meetingId;

    private String meetingEventId;

    private String meetingEventType;

    @JsonProperty("timestamp")
    private long time;

    private boolean notification;

    private MeetingAttributes attributes;

    @JsonIgnore
    private boolean hasGroupDate;

    public MeetingAttributes getAttributes() {
        return attributes;
    }

    public void setAttributes(MeetingAttributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public DefaultUserProfile getOwner() {
        return owner;
    }

    @Override
    public boolean hasGroupDate() {
        return hasGroupDate;
    }

    @Override
    public void setHasGroupDate(boolean hasGroupDate) {
        this.hasGroupDate = hasGroupDate;
    }

    public void setOwner(DefaultUserProfile owner) {
        this.owner = owner;
    }

    @Override
    public String getMeetingId() {
        return meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    @Override
    public String getMeetingEventId() {
        return meetingEventId;
    }

    public void setMeetingEventId(String meetingEventId) {
        this.meetingEventId = meetingEventId;
    }

    @Override
    public Type getMeetingEventType() {
        return Type.valueOf(meetingEventType);
    }

    public void setMeetingEventType(String meetingEventType) {
        this.meetingEventType = meetingEventType;
    }

    public long getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isNotification() {
        return notification;
    }

    public void setNotification(boolean notification) {
        this.notification = notification;
    }

    @Override
    public int compareTo(DefaultMeetingEvent another) {
        return new Date(another.getTime()).compareTo(new Date(getTime()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DefaultMeetingEvent event = (DefaultMeetingEvent) o;

        return meetingEventId != null ? meetingEventId.equalsIgnoreCase(event.meetingEventId) : event.meetingEventId == null;
    }

    @Override
    public int hashCode() {
        return meetingEventId != null ? meetingEventId.hashCode() : 0;
    }

    @Override
    public String toString() {
        return meetingEventId;
    }
}
