/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.app.Application;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import voxeet.com.sdk.core.VoxeetSdkFactory;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.impl.ConferenceSdkService;
import voxeet.com.sdk.core.services.AudioService;
import voxeet.com.sdk.core.services.LocalStatsService;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.core.services.SDKFilePresentationService;
import voxeet.com.sdk.core.services.SDKVideoPresentationService;
import voxeet.com.sdk.core.services.ScreenShareService;
import voxeet.com.sdk.core.services.UserService;
import voxeet.com.sdk.core.services.authenticate.token.RefreshTokenCallback;
import voxeet.com.sdk.json.UserInfo;

public final class VoxeetSdk
extends VoxeetSdkTemplate<ConferenceSdkService> {
    private static VoxeetSdk CurrentInstance;
    private static final String TAG;

    protected static void setInstance(@NonNull VoxeetSdk sdk) {
        CurrentInstance = sdk;
    }

    public static VoxeetSdk getInstance() {
        return CurrentInstance;
    }

    public static synchronized void initialize(@NonNull Application application, @NonNull String appId, @NonNull String password, @NonNull UserInfo userInfo) {
        if (null == CurrentInstance) {
            VoxeetSdk sdk = new VoxeetSdk(application, appId, password, userInfo);
            VoxeetSdk.setInstance(sdk);
            VoxeetSdkFactory.validate((VoxeetSdkTemplate)sdk);
        } else {
            Log.d((String)TAG, (String)"initialize: Instance already started !");
        }
    }

    public static synchronized void initialize(@NonNull Application application, @NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken, @NonNull UserInfo userInfo) {
        if (null == CurrentInstance) {
            VoxeetSdk sdk = new VoxeetSdk(application, accessToken, refreshToken, userInfo);
            VoxeetSdk.setInstance(sdk);
            VoxeetSdkFactory.validate((VoxeetSdkTemplate)sdk);
        } else {
            Log.d((String)TAG, (String)"initialize: Instance already started !");
        }
    }

    private VoxeetSdk(@NonNull Application application_context, @NonNull String appId, @NonNull String password, @NonNull UserInfo userInfo) {
        super(application_context, appId, password, userInfo, false);
    }

    private VoxeetSdk(@NonNull Application application_context, @NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken, @NonNull UserInfo userInfo) {
        super(application_context, accessToken, refreshToken, userInfo, false);
    }

    public Promise<Boolean> logout() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Log.d((String)TAG, (String)"onCall: logout called");
                VoxeetSdk.this.onLogoutCleanLoginSockets();
                Log.d((String)TAG, (String)"onCall: clean awaiting sockets done");
                ((ConferenceSdkService)VoxeetSdk.this.getConferenceService()).logout().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                    public void onCall(@Nullable Boolean result, @NonNull Solver<Object> s) {
                        Log.d((String)TAG, (String)("onCall: logout result := " + result + " ... propagating..."));
                        solver.resolve((Object)result);
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable error) {
                        solver.reject(error);
                    }
                });
            }
        });
    }

    public void onSdkPreinit() {
    }

    protected void initServices() {
        this.getServices().put(ConferenceSdkService.class, new ConferenceSdkService((VoxeetSdkTemplate)this, 60000L));
        this.getServices().put(UserService.class, new UserService((VoxeetSdkTemplate)this));
        this.getServices().put(SDKFilePresentationService.class, new SDKFilePresentationService((VoxeetSdkTemplate)this));
        this.getServices().put(SDKVideoPresentationService.class, new SDKVideoPresentationService((VoxeetSdkTemplate)this));
        this.getServices().put(AudioService.class, new AudioService((VoxeetSdkTemplate)this));
        this.getServices().put(ScreenShareService.class, new ScreenShareService((VoxeetSdkTemplate)this));
        this.getServices().put(MediaService.class, new MediaService((VoxeetSdkTemplate)this));
        this.getServices().put(LocalStatsService.class, new LocalStatsService((VoxeetSdkTemplate)this));
    }

    public UserService getUserService() {
        return (UserService)this.getServiceForKlass(UserService.class);
    }

    public SDKFilePresentationService getFilePresentationService() {
        return (SDKFilePresentationService)this.getServiceForKlass(SDKFilePresentationService.class);
    }

    public SDKVideoPresentationService getVideoPresentationService() {
        return (SDKVideoPresentationService)this.getServiceForKlass(SDKVideoPresentationService.class);
    }

    protected String getTag() {
        return VoxeetSdk.class.getSimpleName();
    }

    static {
        TAG = VoxeetSdk.class.getSimpleName();
    }
}

