/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.models.impl;

import android.support.annotation.NonNull;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import voxeet.com.sdk.models.ConferenceUserStatus;
import voxeet.com.sdk.models.PSTNItem;
import voxeet.com.sdk.models.RecordingStatus;
import voxeet.com.sdk.models.abs.Conference;
import voxeet.com.sdk.models.abs.ConferenceUser;
import voxeet.com.sdk.models.impl.DefaultConferenceInfos;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;
import voxeet.com.sdk.models.impl.DefaultUserProfile;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DefaultConference
implements Conference {
    @JsonIgnore
    private String TAG = DefaultConference.class.getSimpleName();
    @JsonIgnore
    private boolean isOffline;
    @JsonIgnore
    private boolean isDemo = false;
    @JsonIgnore
    private boolean hasBeenCreated = false;
    @JsonIgnore
    private boolean isGuestAccess;
    @JsonIgnore
    private boolean isRecorded = false;
    @JsonIgnore
    private Date startRecordTimestamp;
    @JsonIgnore
    private String recordingUser;
    @JsonIgnore
    private RecordingStatus recordingStatus = RecordingStatus.NOT_RECORDING;
    @JsonProperty(value="conference")
    private DefaultConferenceInfos conferenceInfos;
    private String conferenceId;
    private String conferenceAlias;
    private String conferenceType;
    private String securityToken;
    private String meetingId;
    private String location;
    private String title;
    private String description;
    private DefaultUserProfile ownerProfile;
    private String pstnPinCode;
    private List<DefaultConferenceUser> conferenceUsers = new ArrayList<DefaultConferenceUser>();
    @JsonProperty(value="nodes")
    private List<PSTNItem> pstnItems;
    @JsonProperty(value="e164FallbackPhoneNumber")
    private String fallBackNumber;

    @Override
    public String getFallBackNumber() {
        return this.fallBackNumber;
    }

    public void setFallBackNumber(String fallBackNumber) {
        this.fallBackNumber = fallBackNumber;
    }

    @Override
    public DefaultConferenceInfos getConferenceInfos() {
        return this.conferenceInfos;
    }

    public void setConferenceInfos(DefaultConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Override
    public List<PSTNItem> getPstnItems() {
        return this.pstnItems;
    }

    public void setPstnItems(List<PSTNItem> pstnItems) {
        this.pstnItems = pstnItems;
    }

    @Override
    public boolean hasBeenCreated() {
        return this.hasBeenCreated;
    }

    @Override
    public boolean isObjectValid() {
        return true;
    }

    public void setHasBeenCreated(boolean hasBeenCreated) {
        this.hasBeenCreated = hasBeenCreated;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getMeetingId() {
        return this.meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public DefaultUserProfile getOwnerProfile() {
        return this.ownerProfile;
    }

    public void setOwnerProfile(DefaultUserProfile ownerProfile) {
        this.ownerProfile = ownerProfile;
    }

    @Override
    public String getPstnPinCode() {
        return this.pstnPinCode;
    }

    public void setPstnPinCode(String pstnPinCode) {
        this.pstnPinCode = pstnPinCode;
    }

    @Override
    public String getConferenceId() {
        return this.conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    @Override
    public String getConferenceType() {
        return this.conferenceType;
    }

    public void setConferenceType(String conferenceType) {
        this.conferenceType = conferenceType;
    }

    @Override
    public String getSecurityToken() {
        return this.securityToken;
    }

    @Override
    @NonNull
    public List<DefaultConferenceUser> getConferenceUsers() {
        if (null != this.conferenceUsers) {
            return this.conferenceUsers;
        }
        return new ArrayList<DefaultConferenceUser>();
    }

    @Override
    public int getConferenceRoomSize() {
        if (this.conferenceUsers != null) {
            return this.conferenceUsers.size();
        }
        return 0;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public void setConferenceUsers(List<DefaultConferenceUser> conferenceUsers) {
        this.conferenceUsers = conferenceUsers;
    }

    @Override
    public boolean isOffline() {
        return this.isOffline;
    }

    public void setOffline(boolean offline) {
        this.isOffline = offline;
    }

    @Override
    public boolean isDemo() {
        return this.isDemo;
    }

    public void setDemo(boolean demo) {
        this.isDemo = demo;
    }

    @Override
    public boolean isGuestAccess() {
        return this.isGuestAccess;
    }

    public void setGuestAccess(boolean guestAccess) {
        this.isGuestAccess = guestAccess;
    }

    @Override
    public boolean isRecorded() {
        return this.isRecorded;
    }

    public void setRecorded(boolean recorded) {
        this.isRecorded = recorded;
    }

    @Override
    public Date getStartRecordTimestamp() {
        return this.startRecordTimestamp;
    }

    public void setStartRecordTimestamp(Date startRecordTimestamp) {
        this.startRecordTimestamp = startRecordTimestamp;
    }

    @Override
    public String getRecordingUser() {
        return this.recordingUser;
    }

    @Override
    public ConferenceUser getUserById(final String userId) {
        if (this.conferenceUsers != null) {
            return (ConferenceUser)Iterables.find(this.conferenceUsers, (Predicate)new Predicate<DefaultConferenceUser>(){

                public boolean apply(DefaultConferenceUser input) {
                    return userId.equals(input.getUserId());
                }
            }, null);
        }
        return null;
    }

    public void setRecordingUser(String recordingUser) {
        this.recordingUser = recordingUser;
    }

    @Override
    public boolean isConferenceEmpty() {
        if (this.conferenceUsers == null) {
            return true;
        }
        for (ConferenceUser conferenceUser : this.conferenceUsers) {
            if (conferenceUser.getConferenceStatus() != ConferenceUserStatus.ON_AIR) continue;
            return false;
        }
        return true;
    }

    @Override
    public RecordingStatus getRecordingStatus() {
        return this.recordingStatus;
    }

    @Override
    public boolean isUsersOnAir() {
        if (this.conferenceUsers == null) {
            return true;
        }
        for (ConferenceUser conferenceUser : this.conferenceUsers) {
            if (conferenceUser.getConferenceStatus() != ConferenceUserStatus.ON_AIR) continue;
            return true;
        }
        return false;
    }

    public void setRecordingStatus(RecordingStatus recordingStatus) {
        this.recordingStatus = recordingStatus;
    }

    public void setConferenceAlias(String conferenceAlias) {
        this.conferenceAlias = conferenceAlias;
    }

    public String getConferenceAlias() {
        return this.conferenceAlias;
    }
}

