/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.app.Application;
import android.support.annotation.NonNull;
import eu.codlab.simplepromise.Promise;
import java.util.concurrent.Callable;
import voxeet.com.sdk.core.VoxeetSdkFactory;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.impl.ConferenceSdkService;
import voxeet.com.sdk.core.services.AudioService;
import voxeet.com.sdk.core.services.SDKFilePresentationService;
import voxeet.com.sdk.core.services.ScreenShareService;
import voxeet.com.sdk.core.services.UserService;
import voxeet.com.sdk.json.UserInfo;

public final class VoxeetSdk
extends VoxeetSdkTemplate<ConferenceSdkService> {
    private static VoxeetSdk CurrentInstance;

    protected static void setInstance(@NonNull VoxeetSdk sdk) {
        CurrentInstance = sdk;
    }

    public static VoxeetSdk getInstance() {
        return CurrentInstance;
    }

    public static synchronized void initialize(@NonNull Application application, @NonNull String appId, @NonNull String password, @NonNull UserInfo userInfo) {
        VoxeetSdk sdk = new VoxeetSdk(application, appId, password, userInfo);
        VoxeetSdk.setInstance(sdk);
        VoxeetSdkFactory.validate((VoxeetSdkTemplate)sdk);
    }

    public static synchronized void initialize(@NonNull Application application, @NonNull String accessToken, @NonNull Callable<String> refreshToken, @NonNull UserInfo userInfo) {
        VoxeetSdk sdk = new VoxeetSdk(application, accessToken, refreshToken, userInfo);
        VoxeetSdk.setInstance(sdk);
        VoxeetSdkFactory.validate((VoxeetSdkTemplate)sdk);
    }

    private VoxeetSdk(@NonNull Application application_context, @NonNull String appId, @NonNull String password, @NonNull UserInfo userInfo) {
        super(application_context, appId, password, userInfo, false);
    }

    private VoxeetSdk(@NonNull Application application_context, @NonNull String accessToken, @NonNull Callable<String> refreshToken, @NonNull UserInfo userInfo) {
        super(application_context, accessToken, refreshToken, userInfo, false);
    }

    public Promise<Boolean> logout() {
        return ((ConferenceSdkService)this.getConferenceService()).logout();
    }

    public void onSdkPreinit() {
    }

    protected void initServices() {
        this.getServices().put(ConferenceSdkService.class, new ConferenceSdkService((VoxeetSdkTemplate)this, 10000L));
        this.getServices().put(UserService.class, new UserService((VoxeetSdkTemplate)this));
        this.getServices().put(SDKFilePresentationService.class, new SDKFilePresentationService((VoxeetSdkTemplate)this));
        this.getServices().put(AudioService.class, new AudioService((VoxeetSdkTemplate)this));
        this.getServices().put(ScreenShareService.class, new ScreenShareService((VoxeetSdkTemplate)this));
    }

    public UserService getUserService() {
        return (UserService)this.getServiceForKlass(UserService.class);
    }

    public SDKFilePresentationService getFilePresentationService() {
        return (SDKFilePresentationService)this.getServiceForKlass(SDKFilePresentationService.class);
    }

    protected String getTag() {
        return VoxeetSdk.class.getSimpleName();
    }
}

