/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.models.abs;

import java.util.Date;
import java.util.List;
import voxeet.com.sdk.models.PSTNItem;
import voxeet.com.sdk.models.RecordingStatus;
import voxeet.com.sdk.models.abs.ConferenceUser;
import voxeet.com.sdk.models.impl.DefaultConferenceInfos;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;
import voxeet.com.sdk.models.impl.DefaultUserProfile;

public interface Conference {
    public String getFallBackNumber();

    public DefaultConferenceInfos getConferenceInfos();

    public String getTitle();

    public String getMeetingId();

    public String getLocation();

    public String getDescription();

    public DefaultUserProfile getOwnerProfile();

    public String getPstnPinCode();

    public String getConferenceId();

    public String getConferenceType();

    public String getSecurityToken();

    public List<DefaultConferenceUser> getConferenceUsers();

    public int getConferenceRoomSize();

    public List<PSTNItem> getPstnItems();

    public boolean isOffline();

    public boolean isDemo();

    public boolean isGuestAccess();

    public boolean isRecorded();

    public Date getStartRecordTimestamp();

    public String getRecordingUser();

    public ConferenceUser getUserById(String var1);

    public RecordingStatus getRecordingStatus();

    public boolean isConferenceEmpty();

    public boolean isUsersOnAir();

    public boolean hasBeenCreated();

    public boolean isObjectValid();

    public static interface ConferenceInfo {

        public static enum ConferenceType {
            STANDARD("STANDARD"),
            SCHEDULED("SCHEDULED"),
            DEMO("DEMO"),
            MEET_NOW("MEET_NOW"),
            REPLAY("REPLAY"),
            USER_CONF("USER_CONF"),
            GUEST("GUEST");

            private final String value;

            private ConferenceType(String value) {
                this.value = value;
            }

            public String value() {
                return this.value;
            }

            public static ConferenceType fromId(String value) {
                switch (value) {
                    case "STANDARD": {
                        return STANDARD;
                    }
                    case "SCHEDULED": {
                        return SCHEDULED;
                    }
                    case "DEMO": {
                        return DEMO;
                    }
                    case "MEET_NOW": {
                        return MEET_NOW;
                    }
                    case "REPLAY": {
                        return REPLAY;
                    }
                    case "USER_CONF": {
                        return USER_CONF;
                    }
                    case "GUEST": {
                        return GUEST;
                    }
                }
                throw new IllegalArgumentException("No econference type with id[" + value + "]");
            }
        }
    }
}

